/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.nuiton.jaxx.runtime.swing.list.CheckListModel;

public class DefaultCheckListModel<T>
extends AbstractListModel
implements CheckListModel<T> {
    private static final long serialVersionUID = 1L;
    protected final List<T> data = new ArrayList<T>();
    protected final Set<T> checks = new HashSet<T>();

    public DefaultCheckListModel(Collection<? extends T> data) {
        if (data == null) {
            return;
        }
        for (T object : data) {
            this.data.add(object);
            this.checks.clear();
        }
    }

    public DefaultCheckListModel(T ... data) {
        this((Collection<T>)Arrays.asList(data));
    }

    @Override
    public int getSize() {
        return this.data().size();
    }

    @Override
    public int getOriginalSize() {
        return this.data.size();
    }

    protected List<T> data() {
        return this.data;
    }

    public Object getElementAt(int index) {
        return this.data().get(index);
    }

    @Override
    public boolean isCheckedIndex(int index) {
        return this.checks.contains(this.data().get(index));
    }

    @Override
    public void setCheckedIndex(int index, boolean value) {
        T o = this.data().get(index);
        if (value) {
            this.checks.add(o);
        } else {
            this.checks.remove(o);
        }
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public Collection<T> getCheckedItems() {
        ArrayList<T> items = new ArrayList<T>(this.checks);
        items.retainAll(this.data);
        return Collections.unmodifiableList(items);
    }

    @Override
    public void setCheckedItems(Collection<T> items) {
        ArrayList<T> correctedItems = new ArrayList<T>(items);
        correctedItems.retainAll(this.data);
        this.checks.clear();
        this.checks.addAll(correctedItems);
        this.fireContentsChanged(this, 0, this.checks.size() - 1);
    }
}

