package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class HidorButton extends javax.swing.JToggleButton implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HIDE_TEXT = "hideText";
    public static final String PROPERTY_HIDE_TIP = "hideTip";
    public static final String PROPERTY_SHOW_TEXT = "showText";
    public static final String PROPERTY_SHOW_TIP = "showTip";
    public static final String PROPERTY_TARGET_VISIBLE = "targetVisible";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HIDOR_ICON = "hidor.icon";
    public static final String BINDING_HIDOR_TEXT = "hidor.text";
    public static final String BINDING_HIDOR_TOOL_TIP_TEXT = "hidor.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW8TQRAdX2I7tgkkRERBJCjhQ3TnH2AEIUFWQAYkHKEIN6x9K3uj8+2yO4ePBvET+AnQ0yDRUSEKagoaxF9AiIIWMbv+ODscSlzcnWfmvXkz897+gLzRsHXIksTXcYSiz/27tw4OHrQPeQdvc9PRQqHUMPzlPPBaUAkmcYNwudWw8OoIXt2VfSUjHk2haw0oG3wectPjHBE2ZhEdY6rNSbqWqFiPWSeislhf//rpvQpevvEAEkXqCjTK5nGodJL5BngiQDhLnZ6xasiiLsnQIuqS3kUb2w2ZMfdZnz+FF1BsQEExTWQIl04+suNw+EQh5HsikBrh4oxMM6Cm/p5N7cSIMlLKQQoIi8h0l+MjYUQ75AjLVpdvtfo7UoacTdUuEDnf5wkJXErLhiNNVZmeHNgq+385jRcdWqijYVeehjVcmNFOx/PT46XbzbUgr2MKI6y1/r33Q0oNL7125NKW0GX/rK58/fD9fX183jnqfS6zdMqdtHalpeIahW19ZnjbGEVYvcdUrQUlw0OytrPueoaw5ihN4qjfcN0W7u8x0yOKfPHbx0+rT77MgVeHcihZUGe2/g6UsKdpCzIMEnVz2yk6NVig55LVhjAvOjJCOH09YMg22yIK6C43ElrBesYKJjrapc+/V5rvtsdryJGs8/8tT1eRfwwFEYUi4s7nIwtn+rqiDI8DmVo1y7w5+y6rkTM23HMrc04cmetKEtvXVSfafl07MUcFydzkuv3jqf4CdXJBWcQEAAA=";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.HidorButton.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String hideText;
    protected java.lang.String hideTip;
    protected HidorButton hidor = this;
    protected java.lang.String showText;
    protected java.lang.String showTip;
    protected java.lang.Boolean targetVisible;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComponent target;
    
    
    public JComponent getTarget() {
        return target;
    }
    
    public void setTarget(JComponent target) {
        JComponent oldValue = this.target;
        this.target = target;
        firePropertyChange("target", oldValue, target);
    }
    
    public void setExpandIcon(Icon icon) {
        putClientProperty("expandIcon", icon);
    }
    
    public void setHideIcon(Icon icon) {
        putClientProperty("hideIcon", icon);
    }
    
    protected String updateToolTipText(boolean c) {
        String i = c ? hideTip : showTip;
        return i;
    }
    
    protected String updateText(boolean c) {
        String i = c ? hideText : showText;
        return i;
    }
    
    protected Icon updateIcon(boolean c) {
       String key = c ? "hideIcon" : "showIcon";
       return (Icon) getClientProperty(key);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HidorButton() {
        $initialize();
    }

    public HidorButton(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hidor(java.awt.event.ActionEvent event) {
        setTargetVisible(!targetVisible);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getHideText() {
        return hideText;
    }

    public java.lang.String getHideTip() {
        return hideTip;
    }

    public java.lang.String getShowText() {
        return showText;
    }

    public java.lang.String getShowTip() {
        return showTip;
    }

    public java.lang.Boolean getTargetVisible() {
        return targetVisible;
    }

    public java.lang.Boolean isTargetVisible() {
        return targetVisible !=null && targetVisible;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHideText(java.lang.String newValue) {
        java.lang.String oldValue = this.hideText;
        this.hideText = newValue;
        firePropertyChange(PROPERTY_HIDE_TEXT, oldValue, newValue);
    }

    public void setHideTip(java.lang.String newValue) {
        java.lang.String oldValue = this.hideTip;
        this.hideTip = newValue;
        firePropertyChange(PROPERTY_HIDE_TIP, oldValue, newValue);
    }

    public void setShowText(java.lang.String newValue) {
        java.lang.String oldValue = this.showText;
        this.showText = newValue;
        firePropertyChange(PROPERTY_SHOW_TEXT, oldValue, newValue);
    }

    public void setShowTip(java.lang.String newValue) {
        java.lang.String oldValue = this.showTip;
        this.showTip = newValue;
        firePropertyChange(PROPERTY_SHOW_TIP, oldValue, newValue);
    }

    public void setTargetVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.targetVisible;
        this.targetVisible = newValue;
        firePropertyChange(PROPERTY_TARGET_VISIBLE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHideText() {
        $objectMap.put("hideText", hideText = "");
    }

    protected void createHideTip() {
        $objectMap.put("hideTip", hideTip = _("hidor.hideTip"));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = "");
    }

    protected void createShowTip() {
        $objectMap.put("showTip", showTip = _("hidor.showTip"));
    }

    protected void createTargetVisible() {
        $objectMap.put("targetVisible", targetVisible = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("hidor", this);
        createTargetVisible();
        createHideText();
        createShowText();
        createHideTip();
        createShowTip();
        // inline creation of hidor
        setName("hidor");
        hidor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidor"));
        hidor.putClientProperty("hideIcon", SwingUtil.createActionIcon("collapse"));
        hidor.putClientProperty("showIcon", SwingUtil.createActionIcon("expand"));
        
        addPropertyChangeListener("targetVisible", new PropertyChangeListener() {
        
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
                boolean newValue = (Boolean) evt.getNewValue();
                if (target != null) {
                    target.setVisible(newValue);
                }
            }
        });$completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_ICON, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setIcon(updateIcon(isTargetVisible()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setText(_(updateText(isTargetVisible())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TOOL_TIP_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setToolTipText(_(updateToolTipText(isTargetVisible())));
            }
        });
    }

}