/*
 * #%L
 * JAXX :: Tutorial Validation
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.validation.ui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.validation.*;
import jaxx.demo.validation.ui.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class DemoUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVYz28bRRQep7ETJw2kaROlbdo6LlSJaDeEC5VSQdu0JkmdNMQJqohEGXvH8bTr3e3ubLJVBOJP4E+AOxckbpwQB84cuCD+BYQ4cEW8mfX+mPWsvWpFpDjJzPfevO+b997M5Ls/UdF10OIz7Pua45mMdom2de/Jk8fNZ6TFHhC35VCbWQ4KvgojaOQQTerRuMvQ9cM6N1/pma+sW13bMomZsF6rowmXvTSI2yGEMXRFtmi57kojml7zbc8JvUZBqbx+8/dfI1/rX307gpBvQ3RzQKUyzCpmMlpHI1RnaAZWOsYrBjaPIAyHmkcQ7xQfWzew6+7gLnmBvkRjdVSysQPOGKrmpyx8CHvfZqjcxdSsOeCSoasiVJ10Le0YG1THjFqm5lHtAQwdbNq2MCsxNNWyTAbe6/il5bHQMOTonkDE2jp29GD+vdiwBIZtesTQNeVSfJ11gYhNxjrY1A3iMPT24PA2AlxsOdolpsfQBS6c34tqaxvG7uMEapyjatQA/uf6kBwzG0FnQ2gQo+eICGC8z26TkS43mo9sp0PbOuyqh4/EDl6SMTNpTG2Pz1zhH1ezUQePFKizb201CGQHhq1/l6E5KcRoJmP9mmcYkDeEmJHnGHUhRO1YThdn45IRrPKxG6n50M9DnzKFvdiYDWLYkVKzsi2fC+eF7Ur/fIMyopifCufvNSFBFYBxXha72ISsmJGk42MGB5UjbJnhpkF4EjL0TlaOfhL9tR+iufn7kZeCHWa4XEcNhpnnbhPXha2OVgc7B12W4NC0tLhpxV2lcIiKjgfDDM0f9ve5PZgKOtx8qsNxh2L237nzv/34xw+1sK2dh7VnldBEV4Z2YzuWDYVL+dJvBj3NY9RY2cb22iEqu8SAli5a9oIisEZvGoKD9URtatxc28BuB1wUx37/6ee5z389g0ZqaMKwsF7DHL8JG9JxQAXL0H37w7siorMn4/A5Dd9nYMPagBabxlCxDSkMP0uWjV94iYGppuXoxNmFPGBED8d90GlBoVMUbLP8yz/nG9/fDbUqQOwXM+GxXsVPUYmaBjWJOAR6/V3Z9Cdtl3i6FfdxVWdHkE7jW/uWZcTd7qH43FRJUmSUcTnK/KytBLlcptCtN7uQdgx9dipxaPDUPOCbAdWPGdkE5BLggsa4tKzB749tnu1LVWzbBm0FhcA9ajZmneqywAjvS8tfMDTpmTppWdAtuNgLp0ln1OUNqSEaDYB90ZY/FuLy3xooeYzZQ8gWgOzTDpQ+9OTTKlQmt9R4P6gqPYtTZJhTUHCUEZ+JbuH7ov65ndYWB8t414QRk7agzGvx+rPy+gKsDiI6pIYFUowCuRIFAlXBtW/Jh1YypnWGJgIU38jEMT3JIIH2qb0vXC4OdKkxuGdE3K4ruMl4NVP1GZuf9sV+/TXDauH0NqQpl5mDTdeA9EuzHuQxZLugYhuA1DT7rgPDGPKbEDF5z4LyWD1dxK0WsVldLJGuvN7o8s1Kte08re1VeYH16dPbwyBKre30pamkzxhdvW3e4ihZnb40i/zJ+XAtWyHAqkVS3If+J5mI+fSj+3lk8p7LMh0oZeKofDJ5z/PL5D3PKdPBoxwy9YheSgfWju5+wOaYulQckzOni9Q9iFu06NlJIXZTQkwk/chaXM1eUhajohIjBg9RI77E5ldjIR2ambjjJvU4dzpYjp2UHNMGwcfkVrYolUEry7LcUOZIyr9aHOXdPX9zvZAOksDVXSb+JEV8NIDIZOdVfmSSl1QkOUxNTHpMvPJpHSydpEOyT2s+OuC05q+L11BWGYqsbAAZoiwHDVZWILLJSE+t1yDkUpY6gt00oQAyhBAH5SDEYUMI8bdhfkKz6UBwU/zvI8noXopRsYfJulAkPcmcLqs4CZyalPygHcZqNNnKRpnjpXOrDK+nk1uqBOvrkBy5ESVZ1qtJUSShYY4Le6lD6FGH1+ud4I1UwYw5tOkx8kGf7wL/nMjzDDihOuvAdOHmqzspGb3/gb1xB573uNKkpg5vo4ywboPH/wBTOyfh4xQAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.validation.ui.DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.demo.validation.DemoConfig config;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected jaxx.demo.validation.ui.DemoUIHandler handler;
    protected DemoUI mainFrame = this;
    protected javax.swing.JPanel mainPane;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected jaxx.runtime.swing.StatusMessagePanel p;
    protected jaxx.demo.validation.ui.ValidationTableDemo tableDemo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }
    
    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(java.awt.event.WindowEvent event) {
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.demo.validation.DemoConfig getConfig() {
        return config;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public jaxx.demo.validation.ui.DemoUIHandler getHandler() {
        return handler;
    }

    public javax.swing.JPanel getMainPane() {
        return mainPane;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public jaxx.runtime.swing.StatusMessagePanel getP() {
        return p;
    }

    public jaxx.demo.validation.ui.ValidationTableDemo getTableDemo() {
        return tableDemo;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(tableDemo, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemoUIHandler.class));
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new javax.swing.JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("jaxxdemo.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("jaxxdemo.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("jaxxdemo.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setMnemonic(70);
        menuFileLanguageFR.setToolTipText(_("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("jaxxdemo.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("jaxxdemo.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("jaxxdemo.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("jaxxdemo.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createP() {
        $objectMap.put("p", p = new jaxx.runtime.swing.StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createTableDemo() {
        $objectMap.put("tableDemo", tableDemo = new jaxx.demo.validation.ui.ValidationTableDemo());
        
        tableDemo.setName("tableDemo");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        addChildrenToMainPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setIconImage(jaxx.runtime.SwingUtil.createIcon(getConfig().getOption("application.icon.path")).getImage());
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.createActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.createActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.createActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.createActionIcon("about"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("mainFrame", this);
        createContentLayout();
        createConfig();
        createHandler();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMainPane();
        createTableDemo();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(_("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}