package org.nuiton.jaxx.swing.extra;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class JTrees {

    /** Logger. */
    private static final Log log = LogFactory.getLog(JTrees.class);

    /**
     * Expand all childs of a tree.
     *
     * @param tree the tree to expand
     */
    public static void expandTree(final JTree tree) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                int i = 0;
                while (i < tree.getRowCount()) {
                    tree.expandRow(i++);
                }
            }
        });
    }

    /**
     * Add a listener of tree selection model to expand a new selected node
     * when it is selected.
     *
     * @param tree the tree to treate
     */
    public static void addExpandOnClickListener(final JTree tree) {

        tree.getSelectionModel().addTreeSelectionListener(
                new TreeSelectionListener() {

                    @Override
                    public void valueChanged(final TreeSelectionEvent e) {
                        TreeNode node = (TreeNode)
                                e.getPath().getLastPathComponent();
                        if (node != null && !node.isLeaf()) {

                            SwingUtilities.invokeLater(new Runnable() {

                                @Override
                                public void run() {
                                    for (TreePath path : e.getPaths()) {
                                        if (e.isAddedPath(path) &&
                                            !tree.isExpanded(path)) {
                                            log.info("expand node [" + path
                                                     + "]");
                                            // will expand the node
                                            tree.expandPath(path);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
    }
}
