/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;

public class Item {
    public static final String LABEL_PROPERTY = "label";
    public static final String VALUE_PROPERTY = "value";
    public static final String SELECTED_PROPERTY = "selected";
    private final String id;
    private String label;
    private Object value;
    private boolean selected;
    private List<Item> children;
    private Item parent;
    private PropertyChangeSupport propertyChangeSupport;

    public Item(String id, String label, Object value, boolean selected) {
        this.id = id;
        this.label = label;
        this.value = value;
        this.selected = selected;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        String oldLabel = this.label;
        this.label = label;
        this.firePropertyChange(LABEL_PROPERTY, oldLabel, label);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        this.firePropertyChange(VALUE_PROPERTY, oldValue, value);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChange(SELECTED_PROPERTY, oldSelected, selected);
    }

    public void addChild(Item item) {
        if (this.children == null) {
            this.children = new ArrayList<Item>();
        }
        this.children.add(item);
        item.parent = this;
    }

    public void removeChild(Item item) {
        if (this.children != null) {
            this.children.remove(item);
        }
    }

    public void removeChilds(List<Item> items) {
        if (this.children != null) {
            this.children.removeAll(items);
        }
    }

    public List<Item> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Item>();
        }
        return this.children;
    }

    public Item getParent() {
        return this.parent;
    }

    public void setParent(Item parent) {
        this.parent = parent;
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(property, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.value + "]";
    }
}

