/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime.swing;

import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TabInfo {

    public static String BACKGROUND_PROPERTY = "background";
    public static String DISABLED_ICON_PROPERTY = "disabledIcon";
    public static String DISPLAYED_MNEMONIC_INDEX_PROPERTY = "displayedMnemonicIndex";
    public static String ENABLED_PROPERTY = "enabled";
    public static String FOREGROUND_PROPERTY = "foreground";
    public static String ICON_PROPERTY = "icon";
    public static String MNEMONIC_PROPERTY = "mnemonic";
    public static String TITLE_PROPERTY = "title";
    public static String TOOL_TIP_TEXT_PROPERTY = "toolTipText";
    private String id;
    private Color background;
    private Icon disabledIcon;
    private int displayedMnemonicIndex = -1;
    private boolean enabled = true;
    private Color foreground;
    private Icon icon;
    private int mnemonic = -1;
    private String title;
    private String toolTipText;
    private PropertyChangeSupport propertyChangeSupport;

    public TabInfo() {
    }

    public TabInfo(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public Color getBackground() {
        return background;
    }

    public void setBackground(Color background) {
        Color oldValue = this.background;
        this.background = background;
        firePropertyChange(BACKGROUND_PROPERTY, oldValue, background);
    }

    public Icon getDisabledIcon() {
        return disabledIcon;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        Icon oldValue = this.disabledIcon;
        this.disabledIcon = disabledIcon;
        firePropertyChange(DISABLED_ICON_PROPERTY, oldValue, disabledIcon);
    }

    public int getDisplayedMnemonicIndex() {
        return displayedMnemonicIndex;
    }

    public void setDisplayedMnemonicIndex(int displayedMnemonicIndex) {
        int oldValue = this.displayedMnemonicIndex;
        this.displayedMnemonicIndex = displayedMnemonicIndex;
        firePropertyChange(DISPLAYED_MNEMONIC_INDEX_PROPERTY, oldValue, displayedMnemonicIndex);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        firePropertyChange(ENABLED_PROPERTY, oldValue, enabled);
    }

    public Color getForeground() {
        return foreground;
    }

    public void setForeground(Color foreground) {
        Color oldValue = this.foreground;
        this.foreground = foreground;
        firePropertyChange(FOREGROUND_PROPERTY, oldValue, foreground);
    }

    public Icon getIcon() {
        return icon;
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.icon;
        this.icon = icon;
        firePropertyChange(ICON_PROPERTY, oldValue, icon);
    }

    public int getMnemonic() {
        return mnemonic;
    }

    public void setMnemonic(int mnemonic) {
        int oldValue = this.mnemonic;
        this.mnemonic = mnemonic;
        firePropertyChange(MNEMONIC_PROPERTY, oldValue, mnemonic);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(TITLE_PROPERTY, oldValue, title);
    }

    public String getToolTipText() {
        return toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTipText;
        this.toolTipText = toolTipText;
        firePropertyChange(TOOL_TIP_TEXT_PROPERTY, oldValue, toolTipText);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (propertyChangeSupport == null) {
            propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        return propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        getPropertyChangeSupport().addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        getPropertyChangeSupport().removePropertyChangeListener(property, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyChangeSupport != null) {
            getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}
