/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime.css;

/**
 * Represents a data binding bound to an attribute at runtime.  Used by {@link Pseudoclasses} to keep
 * track of which data bindings are in effect.
 */
public class DataBinding {
    private String id;

    public DataBinding(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DataBinding && ((DataBinding) o).getId().equals(getId());
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}