package org.nuiton.jaxx.demo.component.jaxx.widgets.select;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;

public class FilterableDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz08TQRR+LbZAixYharxhQDFBd0XiCeMPaIhiEQIciL047Q7dwe3MODNrlwsHD978Bzx49WL4H4gnEy9e+R9M+BN8s1u2gC2gsUlnm7ff++Z73+t7X39BTiu4I1TD4SEzgjtbJIocFXLDmtRZfLqxsVzbonVTprqumDRCQfLJZCFbhaKXxrUBp1pBJjdhci2T22Zy50VTCk75EaLZChS02Q6o9ik1Bm73TK5r7a6lyNlIhqp9V1fV3e768WF6P0PLn7IAkUT5RSx76i8IOlVfqECWeQZGKlvkHXEDwhsoTjHewIIu2th8QLR+SZr0LexAfwXykigkM3D3n+yJ6WKqSBooTpRpU6wQToN7Bl6cLMHDl079kC2JtZjXoEY7mgbYSWeBBYYqUgtoWYR4Vpg2llPK+Ja8gVxTeDQwsPIf2ZcsZeeK/ol1i8ESxnt1QbfQUyeG2aTBNHekLvgma4SKGCZ4bAUGrfNRO2kxDlp4Kc0a3kyVzYUGbzNw5VjOvE/rb+ZEZPEjadp1nzX8AL8mqWydRibJt4Brx8El7YvWKtW0N2TUQsq0LlC9UD1hQ5R3lHZ5X/BSdw3MnLTwHD05bk5eUR0G5qQltlhrZRus4FavZuGIOp0R7UxLpgo5FWIYG917O9gBX0VUMtrjvUfbXhMD3+/uqC+tg/3Dee5DcWNnZR1ZXThcUglJlWFWWykZ5tCwwF0icrYKg4l38V6bPF35WhuJ6lHFZcvkWCbnGdE+suX69/e+XX39sw+yC1AIBPEWiMU/h0Hjo/G+CLxIPn4SixtqDeA5bGViWwKyLfAvAJceesSQsRrjHjbmUYQuTZ7uUipqd/ng++ePN/cOncqgxonzZHbcyr2CPOMB4zTefe211nXXFaWmoSc6O6vbFsvYZ0G2t8FUfLp/1m/D0/a4H4X2MROrt78exO9Gz2QwMFCjhK9vS3oKzw3k+Q0SF/XhCgcAAA==";
    private static final Log log = LogFactory.getLog(FilterableDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected FilterableDoubleList<People> doubleList;
    protected JCheckBox enableButton;
    protected JCheckBox filterableButton;
    protected FilterableDoubleListDemoHandler handler;
    protected JCheckBox highlightFilterTextButton;
    protected FilterableDoubleListDemoModel model;
    protected JTextPane result;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FilterableDoubleListDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterableDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo() {
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public FilterableDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public FilterableDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public FilterableDoubleListDemoModel getModel() {
        return model;
    }

    public JTextPane getResult() {
        return result;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(enableButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new FilterableDoubleList<People>());
        
        doubleList.setName("doubleList");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FilterableDoubleListDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JTextPane());
        
        result.setName("result");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new FilterableDoubleListDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createEnableButton();
        createDoubleList();
        createResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 3 property setters
        doubleList.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}