package jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import jaxx.demo.entities.Movie;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MovieContentUI extends AbstractContentUI<Movie> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";
    private static final String BINDING_$JTEXT_PANE0_TEXT = "$JTextPane0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VQU8TQRidVgqUgmArBQImiI2JBrdyLlEQIdIUJRYjsRdnd4d2yOzuODtbFg7Gn+BP0LsXE2+ejAfPHrwY/4IxHrwav9m2u1RXaKw9UDLf996875v34NVXlHIFuriPfV8Tni2pRbTy6u7uPX2fGPI2cQ1BuXQEan0SSZSsoYwZnrsSXapVFLzYhhfXHIs7NrGPoUsVNOLKQ0bcBiFSogvdCMN1i9WwXPK5Jzqsoag41hffvyWfm89eJhHyOagbglHmT0NFkwxUUJKaEmXhpiYuMmzXQYagdh30jqmzNYZd9y62yBP0FA1V0CDHAsgkWuh95IAjwPtcolxhVXelwIZcc2wJiAeb1yVaDESbxHK0PYKlJ4hm46ZmtFq0LadJSdjPeUA3KNGAiSWWaDpCQwOVlLgtSNSZdjmjchvbRKK8mszX3AMYVCtXOwXVmQ4BY4Vy1RAOY6oECqe6QWFJtY+HqEyhvEN82cZMdmE6BdWajb9nSR2e76YcLpQrWCcM+LJdfMGpaprm8OyzXc8OhtIiQ0UvnqihlPDgGJZW+9OD96HUct/0b+5ThEH1Zz736e2XNxsdy03A3ZOxrccSA1bgwuFEqKeRaLzlN09SVtzCvFSD5yEM4hbEaS5GWLVdBnFw3zkF1xRcu4PdBlCkhj6/e59//PEMSm6gEeZgcwOr/k2Ulg0BW3CY6fObK4Gi0YNhJVxpg52CbXccz2is+xzbJtYZ7Cu7TG1GbTKPJcRB9yS54cNS5mKWEirT0x9+5KqvVzqLSYDQmb+2R8tJPUKDrduCNLaDFpu+DHeJZzpRoOIillDfE7xt/YXg5+W4yTOOoBAXLCkEC51dVlma16ltgrtgXIW7GsyhflvsmXYU1k2PyENC6w2puq78O9eg7giTCFVfimfJ9cAy04BJj2BIzFpRu4XFtsOocdgn8VRTOdr4v7TquHQCQ74HYcPEpFJZ+YT998KT3oOtXVPP2SfRgIQ/fn0NddpaZnpiWOmLATJjUZtanlVtr6QvMet9islFvl5ltG5bkOYTKGd7eScK/3JP4fgFC+kR8DMJAAA=";
    private static final Log log = LogFactory.getLog(MovieContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Movie data;
    protected JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MovieContentUI $AbstractContentUI0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTextPane $JTextPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MovieContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MovieContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MovieContentUI() {
        $initialize();
    }

    public MovieContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Movie getData() {
        return data;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(Movie data) {
        Movie oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTextPane get$JTextPane0() {
        return $JTextPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $AbstractContentUI0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JTextPane0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel0);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JTextPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.movie.title")));
        $JScrollPane1.setBorder(new TitledBorder("Picture"));
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        $JScrollPane1.setMinimumSize(SwingUtil.newMinDimension());
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JTextPane0
        $objectMap.put("$JTextPane0", $JTextPane0 = new JTextPane());
        
        $JTextPane0.setName("$JTextPane0");
        $JTextPane0.setEditable(false);
        if ($JTextPane0.getFont() != null) {
            $JTextPane0.setFont($JTextPane0.getFont().deriveFont((float) 11));
        }
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_PANE0_TEXT, true ,"data") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JTextPane0, getHandler().getContent(getData()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ICON, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setIcon(getHandler().getImage(getData()));
            }
        });
    }

}
