package jaxx.demo.feature.databinding;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * Created: 3 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1692 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-21 21:11:57 +0100 (lun., 21 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public class DefaultDemoUIModel implements DemoUIModel {


    protected java.io.File file;
    protected java.io.File file1;
    protected java.lang.Boolean f1 = false;
    protected java.lang.Boolean f0 = false;

    protected javax.swing.JToggleButton t1;
    protected javax.swing.JToggleButton t0;

    public static final String PROPERTY_T1 = "t1";
    public static final String PROPERTY_F1 = "f1";
    public static final String PROPERTY_F0 = "f0";
    public static final String PROPERTY_FILE = "file";

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected static final Log log = LogFactory.getLog(DefaultDemoUIModel.class);

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.lang.Boolean getF0() {
        return f0;
    }

    public java.lang.Boolean getF1() {
        return f1;
    }

    @Override
    public java.io.File getFile() {
        return file;
    }

    public java.io.File getFile1() {
        return file1;
    }

    @Override
    public javax.swing.JToggleButton getT0() {
        return t0;
    }

    @Override
    public javax.swing.JToggleButton getT1() {
        return t1;
    }

    @Override
    public java.lang.Boolean isF0() {
        return f0 != null && f0;
    }

    @Override
    public java.lang.Boolean isF1() {
        return f1 != null && f1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void setF0(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.f0;
        this.f0 = newValue;
        firePropertyChange(PROPERTY_F0, oldValue, newValue);
    }

    @Override
    public void setF1(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.f1;
        this.f1 = newValue;
        firePropertyChange(PROPERTY_F1, oldValue, newValue);
    }

    @Override
    public void setFile(java.io.File newValue) {
        java.io.File oldValue = this.file;
        this.file = newValue;
        firePropertyChange(PROPERTY_FILE, oldValue, newValue);
    }


    public void setT1(javax.swing.JToggleButton newValue) {
        javax.swing.JToggleButton oldValue = this.t1;
        this.t1 = newValue;
        firePropertyChange(PROPERTY_T1, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        pcs.firePropertyChange(name, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(property, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(property, listener);
    }


}
