package org.nuiton.jaxx.application.swing.actionng;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Contract of an application action.
 * <p/>
 * Created on 11/23/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public interface ApplicationAction {

    /**
     * Hook to
     *
     * @return {@code true} if action can be execute, {@code false} otherwise.
     */
    boolean prepare();

    /**
     * Real action code.
     */
    void action();

    /**
     * Executed when action ended with success.
     */
    void done();

    /**
     * Executed when action failed.
     *
     * @param error failure exception
     */
    void fail(Exception error);
}
