/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.util.FileUtil;

@Mojo(name="generateI18nEnumHelper", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateI18nEnumHelperMojo
extends AbstractI18nMojo {
    @Parameter(property="i18n.prefix")
    protected String prefix;
    @Parameter(property="i18n.packageName")
    protected String packageName;
    @Parameter(property="i18n.className", defaultValue="I18nEnumHelper", required=true)
    protected String className;
    @Parameter(property="i18n.outputdirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    protected File outputdirectory;
    @Parameter(property="i18n.enums", required=true)
    protected List<String> enums;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
        }
        File directory = FileUtil.getFileFromFQN((File)this.outputdirectory, (String)this.packageName);
        File file = new File(directory, this.className + ".java");
        Files.createParentDirs((File)file);
        this.getLog().info((CharSequence)("Will generate to " + file));
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            writer.write("// Generated by " + ((Object)((Object)this)).getClass().getName() + " at " + new Date() + "\n");
            writer.write("package " + this.packageName + ";\n");
            writer.write("\n");
            writer.write("import java.util.Locale;\n");
            writer.write("\n");
            writer.write("import static org.nuiton.i18n.I18n.l;\n");
            writer.write("import static org.nuiton.i18n.I18n.n;\n");
            writer.write("import static org.nuiton.i18n.I18n.t;\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("public class " + this.className + " {\n");
            writer.write("\n");
            writer.write("    public static <E extends Enum<E>> String getLabel(E e) {\n");
            writer.write("        return t(getLabelKey(e));\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    public static <E extends Enum<E>> String getLabel(Locale locale, E e) {\n");
            writer.write("        return l(locale, getLabelKey(e));\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    protected static <E extends Enum<E>> String getLabelKey(E e) {\n");
            writer.write("        Class<? extends Enum> aClass = e.getClass();\n");
            writer.write("        return \"" + this.prefix + "\" + aClass.getName() + \".\" + aClass.getSimpleName() + \".\" + e.name();\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    static {\n\n");
            for (String anEnumType : this.enums) {
                Class<?> aClass = Class.forName(anEnumType);
                if (!aClass.isEnum()) {
                    throw new IllegalStateException("Type " + aClass.getName() + " is not an enum.");
                }
                this.getLog().info((CharSequence)("Scan enum: " + aClass.getName()));
                for (Object o : aClass.getEnumConstants()) {
                    Enum e = (Enum)o;
                    writer.write("        n(\"" + this.prefix + aClass.getName() + "." + e.name() + "\");\n");
                }
                writer.write("\n");
            }
            writer.write("    }\n");
            writer.write("}\n");
            writer.close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

