/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParserConfiguration;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class ParserExecutor
extends ThreadPoolExecutor
implements I18nParserConfiguration {
    protected final I18nParserConfiguration configuration;
    protected final List<File> treatedFiles;
    protected final List<File> touchedFiles;
    protected int nbFiles;

    public ParserExecutor(I18nParserConfiguration configuration) {
        super(8, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.configuration = configuration;
        this.touchedFiles = new ArrayList<File>();
        this.treatedFiles = new ArrayList<File>();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ParserTask i18n = (ParserTask)r;
        i18n.registerResult(this.treatedFiles, this.touchedFiles, this.getResult());
    }

    @Override
    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    @Override
    public boolean isSilent() {
        return this.getConfiguration().isSilent();
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.getConfiguration().isShowTouchedFiles();
    }

    @Override
    public Log getLog() {
        return this.getConfiguration().getLog();
    }

    @Override
    public SortedProperties getResult() {
        return this.getConfiguration().getResult();
    }

    public List<File> getTreatedFiles() {
        return this.treatedFiles;
    }

    public List<File> getTouchedFiles() {
        return this.touchedFiles;
    }

    public void clear() {
        this.treatedFiles.clear();
        this.touchedFiles.clear();
        this.nbFiles = 0;
    }

    public void addFile(FileParser parser, File ... files) {
        for (File f : files) {
            ++this.nbFiles;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("[" + this.nbFiles + "] " + f));
            }
            this.execute(new ParserTask(parser, f));
        }
    }

    public void terminatesAndWaits() throws InterruptedException {
        this.shutdown();
        if (this.isVerbose()) {
            if (this.nbFiles == 0) {
                this.getLog().info((CharSequence)"No file consumed.");
            } else {
                this.getLog().info((CharSequence)("Will waits until all files (" + this.nbFiles + ") are consumed (still " + this.getNbFilesToTreate() + " file(s) to consume)"));
            }
        }
        try {
            this.awaitTermination(2L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.getLog().error((Throwable)e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("A task was consumed, still " + this.getNbFilesToTreate() + " file(s) to treate."));
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"Executor is terminated.");
        }
    }

    protected I18nParserConfiguration getConfiguration() {
        return this.configuration;
    }

    protected int getNbFilesToTreate() {
        return this.nbFiles - this.treatedFiles.size();
    }

    class ParserTask
    implements Runnable {
        protected final FileParser parser;
        protected final File file;
        protected long startingTime;
        protected long endingTime;

        ParserTask(FileParser parser, File file) {
            this.parser = parser;
            this.file = file;
        }

        @Override
        public void run() {
            this.startingTime = System.nanoTime();
            if (ParserExecutor.this.getLog().isDebugEnabled()) {
                ParserExecutor.this.getLog().debug((CharSequence)("starting action for " + this.file));
            }
            try {
                this.parser.parseFile(this.file);
            }
            catch (Exception e) {
                if (ParserExecutor.this.getLog().isErrorEnabled()) {
                    ParserExecutor.this.getLog().error((CharSequence)("could not parse file " + this.file), (Throwable)e);
                }
            }
            finally {
                if (ParserExecutor.this.getLog().isDebugEnabled()) {
                    ParserExecutor.this.getLog().debug((CharSequence)("ending action for " + this.file));
                }
                this.endingTime = System.nanoTime();
            }
        }

        public String toString() {
            return super.toString() + " - " + this.file;
        }

        protected File getFile() {
            return this.file;
        }

        protected long getDelay() {
            return this.endingTime - this.startingTime;
        }

        protected void destroy() {
            this.parser.destroy();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void registerResult(List<File> treatedFiles, List<File> touchedFiles, SortedProperties result) {
            try {
                String delay;
                treatedFiles.add(this.file);
                if (ParserExecutor.this.getLog().isDebugEnabled()) {
                    delay = PluginHelper.convertTime((long)this.getDelay());
                    ParserExecutor.this.getLog().debug((CharSequence)("[" + treatedFiles.size() + "] " + this.file + " in " + delay));
                }
                if (this.parser.isTouched()) {
                    touchedFiles.add(this.file);
                    if (ParserExecutor.this.isShowTouchedFiles()) {
                        ParserExecutor.this.getLog().info((CharSequence)("touch " + this.file));
                    }
                    if (ParserExecutor.this.isVerbose()) {
                        delay = PluginHelper.convertTime((long)this.getDelay());
                        ParserExecutor.this.getLog().info((CharSequence)("[" + treatedFiles.size() + "] touchs " + this.file + " in " + delay));
                    }
                    result.putAll((Map)this.parser.getResult());
                }
            }
            finally {
                this.destroy();
            }
        }
    }
}

