/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: I18nParserConfiguration.java 1882 2011-02-14 15:54:14Z tchemit $
 * $HeadURL: https://nuiton.org/svn/i18n/tags/i18n-3.0/i18n-maven-plugin/src/main/java/org/nuiton/i18n/plugin/parser/I18nParserConfiguration.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.parser;

import org.apache.maven.plugin.logging.Log;
import org.nuiton.io.SortedProperties;

/**
 * Shared configuration for a parser mojo.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public interface I18nParserConfiguration {

    boolean isVerbose();

    boolean isSilent();

    boolean isShowTouchedFiles();

    Log getLog();

    SortedProperties getResult();
}
