/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags;

/**
 * Interface of the tag handlers.
 * It permits to get the right class or the right attribiute names to generate for the common tags.
 * It also permits to know which listeners to add for the binding
 *
 * @author kmorin
 */
public interface TagHandler {

    public Class getClassToGenerate();

    public String getAttrToGenerate(String attr);

    public String getDefaultConstructor();

    public boolean hasEventInfosAboutMethod(String methodName);

    public Class getEventInfosListenerClass(String methodName);

    public String getEventInfosAddListenerMethodName(String methodName);

    public String getEventInfosRemoveListenerMethodName(String methodName);

    public String getEventInfosModelName(String methodName);

}
