/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.model;

//~--- JDK imports ------------------------------------------------------------

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Base object to represent the model of the guix files
 *
 * @author morin
 */
public class GuixModelObject {

    /** The children that the object contains */
    private List<GuixModelObject> children = new ArrayList<GuixModelObject>();

    /** The descriptor of the attributes of the object */
    private List<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>();

    /**
     * The stylesheets associated to the object
     * (in case the object is a root model object)
     */
    private List<StyleSheet> styleSheets = new ArrayList<StyleSheet>();

    /**
     * The stylesheets files associated to the object
     * (in case the object is a root model object)
     */
    private List<File> cssFiles = new ArrayList<File>();

    /** The descriptor the class of the object */
    private ClassDescriptor classDescriptor;

    /** The id of the object */
    private String id;

    /** The contructor parameters fro this object */
    private String constructor;

    /** The contructor parameters fro this object */
    private boolean javaBean = true;

    /** The javaDoc of the object */
    private String javadoc;

    /** The component containing the object */
    private GuixModelObject parent;

    /** The style class of the object */
    private String styleClass;

    /**
     * Constructor
     *
     * @param id the id of the object
     * @param javadoc the javadoc of the object
     * @param styleClass the styleclass of the object
     */
    public GuixModelObject(String id, String constructor, String javadoc, String styleClass) {
        this.id         = id;
        this.constructor = constructor;
        this.javadoc    = javadoc;
        this.styleClass = styleClass;
    }

    public List<AttributeDescriptor> getAttributeDescriptors() {
        return attributeDescriptors;
    }

    public void setAttributeDescriptors(List<AttributeDescriptor> attributeDescriptors) {
        this.attributeDescriptors = attributeDescriptors;
    }

    public List<GuixModelObject> getChildren() {
        return children;
    }

    public void setChildren(List<GuixModelObject> children) {
        this.children = children;
    }

    public ClassDescriptor getClassDescriptor() {
        return classDescriptor;
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConstructor() {
        return constructor;
    }

    public void setConstructor(String constructor) {
        this.constructor = constructor;
    }

    public boolean isJavaBean() {
        return javaBean;
    }

    public void setJavaBean(boolean javaBean) {
        this.javaBean = javaBean;
    }
    
    public GuixModelObject getParent() {
        return parent;
    }

    public void setParent(GuixModelObject parent) {
        this.parent = parent;
    }

    public String getJavadoc() {
        return javadoc;
    }

    public void setJavadoc(String javadoc) {
        this.javadoc = javadoc;
    }

    public List<StyleSheet> getStyleSheets() {
        return styleSheets;
    }

    public void setStyleSheets(List<StyleSheet> styleSheets) {
        this.styleSheets = styleSheets;
    }

    public List<File> getCssFiles() {
        return cssFiles;
    }

    public void setCssFiles(List<File> cssFiles) {
        this.cssFiles = cssFiles;
    }
    
    public String getStyleClass() {
        return styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}
