/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plantuml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class PlantumlTemplatesGenerator
extends ObjectModelGenerator {
    private boolean _loginit = true;

    private void log(String str) {
        try {
            FileWriter log;
            String path = "/tmp/log.yaml.txt";
            if (this._loginit) {
                log = new FileWriter(path, false);
                log.close();
                this._loginit = false;
            }
            log = new FileWriter(path, true);
            log.write("[LOG] " + str + "\n");
            log.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateFromModel(Writer output, ObjectModel input) throws IOException {
        LinkedHashMap<ObjectModelAttribute, ObjectModelClass> linksOME = new LinkedHashMap<ObjectModelAttribute, ObjectModelClass>();
        output.write("@startuml\n\n");
        for (ObjectModelClass class_tmp : input.getClasses()) {
            void var6_6;
            String string = "";
            if (class_tmp.getStereotypes().size() > 0) {
                void var6_9;
                String string2 = "<<";
                boolean first = true;
                for (String str : class_tmp.getStereotypes()) {
                    if (first) {
                        String string3 = (String)var6_9 + str;
                        first = false;
                        continue;
                    }
                    String string4 = (String)var6_9 + " ," + str;
                }
                String string5 = (String)var6_9 + ">>";
            }
            String className = class_tmp.getName();
            output.write("class " + className + (String)var6_6 + " {\n");
            for (ObjectModelAttribute attribute_tmp : class_tmp.getAttributes()) {
                String attributeName = attribute_tmp.getName();
                String attributeType = attribute_tmp.getType();
                if (attribute_tmp.referenceClassifier()) {
                    linksOME.put(attribute_tmp, class_tmp);
                    continue;
                }
                output.write("  -" + attributeName + " : " + attributeType + "\n");
            }
            for (ObjectModelOperation operation_tmp : class_tmp.getOperations()) {
                String operationName = operation_tmp.getName();
                String operationReturnType = operation_tmp.getReturnType();
                output.write("  +" + operationName + "(");
                boolean first = true;
                for (ObjectModelParameter param : operation_tmp.getParameters()) {
                    String parameterName = param.getName();
                    String parameterType = param.getType();
                    if (first) {
                        first = false;
                    } else {
                        output.write(", ");
                    }
                    output.write(parameterName + " : " + parameterType);
                }
                output.write(") : " + operationReturnType + "\n");
            }
            output.write("}\n\n");
        }
        for (ObjectModelEnumeration enumeration_tmp : input.getEnumerations()) {
            String string = enumeration_tmp.getName();
            String enumerationStereotype = "";
            if (enumeration_tmp.getStereotypes().contains("entity")) {
                enumerationStereotype = " <<entity>>";
            }
            output.write("enum " + string + enumerationStereotype + " {\n");
            output.write("}\n\n");
        }
        for (ObjectModelInterface interface_tmp : input.getInterfaces()) {
            String string = interface_tmp.getName();
            String interfaceStereotype = "";
            if (interface_tmp.getStereotypes().contains("entity")) {
                interfaceStereotype = " <<entity>>";
            }
            output.write("interface " + string + interfaceStereotype + " {\n");
            output.write("}\n\n");
        }
        for (ObjectModelAttribute attribute_tmp : linksOME.keySet()) {
            if (attribute_tmp.isComposite() && attribute_tmp.referenceClassifier()) {
                output.write(((ObjectModelClassifier)linksOME.get(attribute_tmp)).getName() + " *-- " + attribute_tmp.getClassifier().getName() + "\n");
                continue;
            }
            if (attribute_tmp.isAggregate() && attribute_tmp.referenceClassifier()) {
                output.write(((ObjectModelClassifier)linksOME.get(attribute_tmp)).getName() + " o-- " + attribute_tmp.getClassifier().getName() + "\n");
                continue;
            }
            if (!attribute_tmp.isNavigable() && attribute_tmp.referenceClassifier()) {
                output.write(attribute_tmp.getClassifier().getName() + " --> " + ((ObjectModelClassifier)linksOME.get(attribute_tmp)).getName() + "\n");
                continue;
            }
            if (!attribute_tmp.isNavigable() || !attribute_tmp.referenceClassifier()) continue;
            output.write(attribute_tmp.getClassifier().getName() + " -- " + ((ObjectModelClassifier)linksOME.get(attribute_tmp)).getName() + "\n");
        }
        LinkedHashMap associationClass = new LinkedHashMap();
        for (ObjectModelClassifier objectModelClassifier : input.getClassifiers()) {
            for (ObjectModelAttribute attribute : objectModelClassifier.getAttributes()) {
                if (!attribute.hasAssociationClass()) continue;
                String key = attribute.getAssociationClass().getName();
                String value = objectModelClassifier.getName();
                if (associationClass.containsKey(key)) {
                    ((LinkedList)associationClass.get(key)).add(value);
                    continue;
                }
                associationClass.put(key, new LinkedList());
                ((LinkedList)associationClass.get(key)).add(value);
            }
        }
        for (Map.Entry entry : associationClass.entrySet()) {
            boolean first = true;
            output.write("(");
            for (String value : (LinkedList)entry.getValue()) {
                if (first) {
                    output.write(value);
                    first = false;
                    continue;
                }
                output.write(", " + value);
            }
            output.write(") .. " + (String)entry.getKey() + "\n");
        }
        for (ObjectModelClass objectModelClass : input.getClasses()) {
            for (ObjectModelClass superClassOM : objectModelClass.getSuperclasses()) {
                output.write(superClassOM.getName() + " <|-- " + objectModelClass.getName());
            }
        }
        output.write("\n@enduml");
    }

    public static String afterLastPoint(String input) {
        String str = new StringBuffer(input).reverse().toString();
        String res = "";
        char[] arr$ = str.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character car = Character.valueOf(arr$[i$]);
            if (car.equals(Character.valueOf('.'))) {
                return res;
            }
            res = car.toString() + res;
        }
        return res;
    }

    public void applyTemplate(ObjectModel model, File destDir) throws IOException {
        super.applyTemplate(model, destDir);
        try {
            File plantuml = new File(destDir + File.separator + this.getFilenameForModel(model));
            SourceFileReader reader = new SourceFileReader(plantuml);
            List lst = reader.getGeneratedImages();
            new File(((GeneratedImage)lst.get(0)).getPngFile(), destDir + File.separator + model.getName() + ".png");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getFilenameForModel(ObjectModel model) {
        return model.getName() + ".plantuml";
    }
}

