/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.WriterReport;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.util.FileUtil;

public class ZargoChainedFileWriter
extends BaseChainedFileWriter {
    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};

    public ZargoChainedFileWriter() {
        super(new String[0]);
    }

    public String getInputProtocol() {
        return "zargo";
    }

    public String getOutputProtocol(String modelType) {
        return "xmi";
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("zargo:") || include.endsWith(".zargo") || include.endsWith(".zuml");
    }

    public String getDefaultIncludes() {
        return "**/*.zargo";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "xmi";
    }

    public String getDefaultTestInputDirectory() {
        return "src/test/xmi";
    }

    public String getDefaultTestOutputDirectory() {
        return "test-xmi";
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDirectory, Map<File, List<File>> filesByRoot, Map<File, List<File>> resourcesByFile) throws IOException {
        for (Map.Entry<File, List<File>> entry : filesByRoot.entrySet()) {
            File inputDirectory = entry.getKey();
            List<File> files = entry.getValue();
            if (configuration.isVerbose()) {
                this.getLog().info((CharSequence)("Expanding " + files.size() + " xmi file(s) from " + inputDirectory));
            }
            for (File file : files) {
                File mirrorDirectory = FileUtil.getRelativeFile((File)inputDirectory, (File)outputDirectory, (File)file.getParentFile());
                this.expandFile(file, mirrorDirectory, XMI_FILE_FILTER, configuration);
                this.copyResources(configuration, outputDirectory, inputDirectory, file, resourcesByFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandFile(File src, File dst, String[] includes, ChainedFileWriterConfiguration configuration) throws IOException {
        ZipFile zipFile = new ZipFile(src);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            String name = nextElement.getName();
            for (String include : includes) {
                WriterReport writerReport;
                if (!DirectoryScanner.match((String)include, (String)name)) continue;
                if (configuration.isVerbose()) {
                    this.getLog().info((CharSequence)("matching name : " + name + " with pattern " + include));
                }
                File dstFile = new File(dst, name);
                if (!configuration.isOverwrite() && dstFile.exists() && nextElement.getTime() <= dstFile.lastModified()) continue;
                if (configuration.isVerbose()) {
                    this.getLog().info((CharSequence)("will expand : " + name + " to " + dstFile));
                }
                if ((writerReport = this.getWriterReport()) != null) {
                    writerReport.addFile(((Object)((Object)this)).getClass().getName(), dstFile, false);
                }
                PluginHelper.createDirectoryIfNecessary((File)dst);
                InputStream inputStream = zipFile.getInputStream(nextElement);
                FileOutputStream outStream = new FileOutputStream(dstFile);
                try {
                    IOUtil.copy((InputStream)inputStream, (OutputStream)outStream, (int)2048);
                }
                finally {
                    outStream.close();
                }
            }
        }
    }
}

