package org.nuiton.eugene.plugin;

/*
 * #%L
 * EUGene :: Maven plugin
 * %%
 * Copyright (C) 2006 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;
import org.nuiton.eugene.plugin.renderer.StereotypesReportRenderer;

import java.util.Locale;
import java.util.Map;

/**
 * To report a {@link TagValueDefinitionProvider}.
 * <p/>
 * Created on 5/31/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.10
 */
@Mojo(name = "stereotypes-report", requiresProject = true, requiresReports = true,
      requiresDependencyResolution = ResolutionScope.COMPILE)
public class StereotypesReport extends AbstractEugeneReport<StereotypeDefinitionProvider> {

    /**
     * Name of the stereotypes provider.
     * <p/>
     * This is the role-hint given to the tag value provider to describe.
     */
    @Parameter(property = "eugene.providerName", defaultValue = "${project.artifactId}", required = true)
    protected String providerName;

    @Component(role = StereotypeDefinitionProvider.class)
    protected Map<String, StereotypeDefinitionProvider> providers;

    @Override
    protected StereotypeDefinitionProvider initData(Locale locale) throws MavenReportException {

        StereotypeDefinitionProvider provider = providers.get(providerName);

        if (provider == null) {

            String errorMessage = i18n.format(getOutputName(), locale, "stereotypeProvider.not.found", providerName);
            throw new MavenReportException(errorMessage);

        }

        provider.init();

        return provider;

    }

    @Override
    protected StereotypesReportRenderer createRenderer(Locale locale, StereotypeDefinitionProvider data) {

        StereotypesReportRenderer renderer = new StereotypesReportRenderer(
                getSink(), i18n, locale, getOutputName(), javaDocDestDir, jxrDestDir, data);
        return renderer;

    }

    @Override
    public String getOutputName() {
        return "stereotypes-report";
    }

}
