/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public abstract class AbstractJavaBeanTransformer
extends ObjectModelTransformerToJava {
    public static final String DEFAULT_CONSTANT_PREFIX = "PROPERTY_";

    protected void createPropertyConstant(ObjectModelClassifier output, ObjectModelAttribute attr, String prefix, Set<String> constantNames) {
        String attrName = this.getAttributeName(attr);
        String constantName = prefix + this.builder.getConstantName(attrName);
        if (!constantNames.contains(constantName)) {
            this.addConstant(output, constantName, String.class, "\"" + attrName + "\"", (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        }
    }

    protected String getAttributeName(ObjectModelAttribute attr) {
        String attrName = attr.getName();
        if (attr.hasAssociationClass()) {
            String assocAttrName = JavaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            attrName = JavaGeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
        }
        return attrName;
    }

    protected String getAttributeType(ObjectModelAttribute attr) {
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            attrType = attr.getAssociationClass().getName();
        }
        return attrType;
    }

    protected boolean containsMutiple(List<ObjectModelAttribute> attributes) {
        boolean result = false;
        for (ObjectModelAttribute attr : attributes) {
            if (!JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void createProperty(ObjectModelClass output, ObjectModelAttribute attr, boolean usePCS, boolean generateBooleanGetMethods) {
        boolean booleanProperty;
        String attrName = this.getAttributeName(attr);
        String attrType = this.getAttributeType(attr);
        boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr);
        String constantName = this.getConstantName(attrName);
        String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
        if (multiple) {
            this.createGetChildMethod(output, attrName, attrType, simpleType);
            this.createIsEmptyMethod(output, attrName);
            this.createSizeMethod(output, attrName);
            this.createAddChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createAddAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            this.createRemoveChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createRemoveAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            attrType = JavaGeneratorUtil.getAttributeInterfaceType((ObjectModelParameter)attr, (boolean)true);
            simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
        }
        if ((booleanProperty = JavaGeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attr)) && !multiple) {
            this.createGetMethod(output, attrName, attrType, "is");
        }
        if (multiple || !booleanProperty || generateBooleanGetMethods) {
            this.createGetMethod(output, attrName, attrType, "get");
        }
        this.createSetMethod(output, attrName, attrType, simpleType, constantName, usePCS);
        this.addAttribute((ObjectModelClassifier)output, attrName, attrType, "", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
    }

    protected List<ObjectModelAttribute> getProperties(ObjectModelClass input) {
        List attributes = (List)input.getAttributes();
        ArrayList<ObjectModelAttribute> attrs = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            attrs.add(attr);
        }
        return attrs;
    }

    protected void createGetMethod(ObjectModelClass output, String attrName, String attrType, String methodPrefix) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + ";\n" + "    ");
    }

    protected void createGetChildMethod(ObjectModelClass output, String attrName, String attrType, String simpleType) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "int", "index");
        this.setOperationBody(operation, "\n        " + simpleType + " o = getChild(" + attrName + ", index);\n" + "        return o;\n" + "    ");
    }

    protected void createIsEmptyMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("is", attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null || " + attrName + ".isEmpty();\n" + "    ");
    }

    protected void createSizeMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("size", attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null ? 0 : " + attrName + ".size();\n" + "    ");
    }

    protected void createAddChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("add", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder("\n        " + methodName + "().add(" + attrName + ");\n" + "    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n" + "    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createAddAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("addAll", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder("\n        " + methodName + "().addAll(" + attrName + ");\n" + "    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n" + "    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("remove", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n        boolean removed = " + methodName + "().remove(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n" + "        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("removeAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  removed = " + methodName + "().removeAll(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n" + "        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("contains", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean contains = " + methodName + "().contains(" + attrName + ");\n" + "        return contains;\n" + "    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("containsAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  contains = " + methodName + "().containsAll(" + attrName + ");\n" + "        return contains;\n" + "    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createSetMethod(ObjectModelClass output, String attrName, String attrType, String simpleType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        if (usePCS) {
            String methodName = this.getJavaBeanMethodName("get", attrName);
            this.setOperationBody(operation, "\n        " + simpleType + " oldValue = " + methodName + "();\n" + "        this." + attrName + " = " + attrName + ";\n" + "        firePropertyChange(" + constantName + ", oldValue, " + attrName + ");\n" + "    ");
        } else {
            this.setOperationBody(operation, "\n        this." + attrName + " = " + attrName + ";\n" + "    ");
        }
    }

    protected void addSerializable(ObjectModelClass input, ObjectModelClass output, boolean interfaceFound) {
        if (!interfaceFound) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        long serialVersionUID = JavaGeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)input);
        this.addConstant((ObjectModelClassifier)output, "serialVersionUID", "long", serialVersionUID + "L", (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
    }

    protected boolean addInterfaces(ObjectModelClass input, ObjectModelClassifier output, String extraInterfaceName) {
        boolean foundSerializable = false;
        HashSet<String> added = new HashSet<String>();
        for (ObjectModelInterface parentInterface : input.getInterfaces()) {
            String fqn = parentInterface.getQualifiedName();
            added.add(fqn);
            this.addInterface(output, fqn);
            if (!Serializable.class.getName().equals(fqn)) continue;
            foundSerializable = true;
        }
        if (extraInterfaceName != null && !added.contains(extraInterfaceName)) {
            this.addInterface(output, extraInterfaceName);
        }
        return foundSerializable;
    }

    protected void createPropertyChangeSupport(ObjectModelClass output) {
        this.addAttribute((ObjectModelClassifier)output, "pcs", PropertyChangeSupport.class, "new PropertyChangeSupport(this)", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.TRANSIENT});
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "oldValue");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        pcs.firePropertyChange(propertyName, oldValue, newValue);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        firePropertyChange(propertyName, null, newValue);\n    ");
    }

    protected void createGetChildMethod(ObjectModelClass output) {
        ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)output, "getChild", "<T> T", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addImport((ObjectModelClassifier)output, List.class);
        this.addParameter(getChild, "java.util.Collection<T>", "childs");
        this.addParameter(getChild, "int", "index");
        this.setOperationBody(getChild, "\n        T result = null;\n        if (childs != null) {\n            if (childs instanceof List) {\n                if (index < childs.size()) {\n                    result = ((List<T>) childs).get(index);\n                }\n            } else {\n                int i = 0;\n                for (T o : childs) {\n                    if (index == i) {\n                        result = o;\n                        break;\n                    }\n                    i++;\n                }\n            }\n        }\n        return result;\n");
    }

    protected void generateI18nBlockAndConstants(ObjectModelClass input, ObjectModelClassifier output) {
        String i18nPrefix = JavaGeneratorUtil.getI18nPrefixTagValue((ObjectModelElement)input, (ObjectModel)((ObjectModel)this.model));
        if (!StringUtils.isEmpty((CharSequence)i18nPrefix)) {
            this.generateI18nBlock((ObjectModelClassifier)input, output, i18nPrefix);
        }
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input, DEFAULT_CONSTANT_PREFIX);
        this.setConstantPrefix(prefix);
        Set constantNames = this.addConstantsFromDependency((ObjectModelClassifier)input, output);
        for (ObjectModelAttribute attr : this.getProperties(input)) {
            this.createPropertyConstant(output, attr, prefix, constantNames);
        }
    }

    protected void addDefaultMethodForNoneBeanSuperClass(ObjectModelClass output, boolean usePCS, List<ObjectModelAttribute> properties) {
        boolean hasAMultipleProperty;
        if (usePCS) {
            this.createPropertyChangeSupport(output);
        }
        if (hasAMultipleProperty = this.containsMutiple(properties)) {
            this.createGetChildMethod(output);
        }
    }
}

