package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesTagValues.java 1301 2013-09-29 14:23:58Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.7.2/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesTagValues.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.EugeneTagValues;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.6
 */
public interface JavaTemplatesTagValues extends EugeneTagValues {

    /**
     * Tag value to set if do not want any pcs (says PropertyChangeSupport in a generated bean).
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#isNoPCS(ObjectModel, ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify to not generate any propertyChange " +
                            "code for a class or any class of a model")
    String TAG_NO_PCS = "noPCS";

    /**
     * Tag value to use a super class for generated bean.
     * <p/>
     * If the bean needs Property change support (says you do not add the {@link #TAG_NO_PCS} on classifier or model,
     * then your class must provide evrything for it.
     * <p/>
     * More over, if you use some collections in your bean you must also define
     * two method named {@code getChild(Collection list, int index)} and
     * {@code getChild(List list, int index)}
     * <p/>
     * See new code to know minimum stuff to add in your class for this purpose.
     * <pre>
     * public abstract class AbstractBean implements Serializable {
     *
     *     private static final long serialVersionUID = 1L;
     *
     *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
     *
     *     public void addPropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(listener);
     *     }
     *
     *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(propertyName, listener);
     *     }
     *
     *     public void removePropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(listener);
     *     }
     *
     *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(propertyName, listener);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
     *         pcs.firePropertyChange(propertyName, oldValue, newValue);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object newValue) {
     *         firePropertyChange(propertyName, null, newValue);
     *     }
     *
     *     protected <T> T getChild(Collection<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     *
     *     protected <T> T getChild(List<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     * }
     * </pre>
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getBeanSuperClassTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with bean generator)")
    String TAG_BEAN_SUPER_CLASS = "beanSuperClass";

    /**
     * Tag value to use a super class for generated bean.
     * <p/>
     * If the bean needs Property change support (says you do not add the {@link #TAG_NO_PCS} on classifier or model,
     * then your class must provide evrything for it.
     * <p/>
     * More over, if you use some collections in your bean you must also define
     * two method named {@code getChild(Collection list, int index)} and
     * {@code getChild(List list, int index)}
     * <p/>
     * See new code to know minimum stuff to add in your class for this purpose.
     * <pre>
     * public abstract class AbstractBean implements Serializable {
     *
     *     private static final long serialVersionUID = 1L;
     *
     *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
     *
     *     public void addPropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(listener);
     *     }
     *
     *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.addPropertyChangeListener(propertyName, listener);
     *     }
     *
     *     public void removePropertyChangeListener(PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(listener);
     *     }
     *
     *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
     *         pcs.removePropertyChangeListener(propertyName, listener);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
     *         pcs.firePropertyChange(propertyName, oldValue, newValue);
     *     }
     *
     *     protected void firePropertyChange(String propertyName, Object newValue) {
     *         firePropertyChange(propertyName, null, newValue);
     *     }
     *
     *     protected <T> T getChild(Collection<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     *
     *     protected <T> T getChild(List<T> list, int index) {
     *         return CollectionUtil.getOrNull(list, index);
     *     }
     * }
     * </pre>
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanSuperClassTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.5.6
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated simple bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_SUPER_CLASS = "simpleBeanSuperClass";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanClassNamePrefixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on class name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX = "simpleBeanClassNamePrefix";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanClassNameSuffixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on class name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX = "simpleBeanClassNameSuffix";

    /**
     * To generate an interface of each simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#isSimpleBeanGenerateInterface(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To generate an interface for each bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_GENERATE_INTERFACE = "simpleBeanGenerateInterface";

    /**
     * Tag value to use a super interface for generated interfaces on simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanInterfaceSuperClassTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated interfaces " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS = "simpleBeanInterfaceSuperClass";

    /**
     * To add a prefix on the name of each generated interface of a simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanInterfaceNamePrefixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on interface name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX = "simpleBeanInterfaceNamePrefix";

    /**
     * To add a prefix on the name of each generated interface of a simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanInterfaceNameSuffixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on interface name of generated bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX = "simpleBeanInterfaceNameSuffix";

    /**
     * To generate a factory of generated simple beans.
     * <p/>
     * You must use it on the complete model.
     *
     * @see JavaTemplatesGeneratorUtil#isSimpleBeanGenerateFactory(ObjectModel)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class},
            documentation = "To generate a factory of simple bean.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_GENERATE_FACTORY = "simpleBeanGenerateFactory";

    /**
     * To generate a factory of generated simple beans.
     * <p/>
     * You must use it on the complete model.
     *
     * @see JavaTemplatesGeneratorUtil#isSimpleBeanGenerateDefaults(ObjectModel, ObjectModelClassifier)
     * @since 2.7.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To generate defaults class with simple operations on the type.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_GENERATE_DEFAULTS = "simpleBeanGenerateDefaults";

    /**
     * Tag value to use a super super-class for generated defaults class of a
     * simple bean.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanDefaultsSuperClassTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.7.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To specify a super-class to used on generated defaults classes" +
                            "for a bean or any bean of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS = "simpleBeanDefaultsSuperClass";

    /**
     * To add a prefix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.7.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a prefix on class name of generated defaults bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX = "simpleBeanDefaultsClassNamePrefix";

    /**
     * To add a suffix on the name of each generated bean class.
     * <p/>
     * You can globaly use it on the complete model or to a specific classifier.
     *
     * @see JavaTemplatesGeneratorUtil#getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModel, ObjectModelClassifier)
     * @since 2.6.2
     */
    @ModelPropertiesUtil.TagValueDefinition(
            target = {ObjectModel.class, ObjectModelClassifier.class},
            documentation = "To add a suffix on class name of generated defaults bean " +
                            "for a class or any class of a model.\n" +
                            "(only effective with simple bean generator)")
    String TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX = "simpleBeanDefaultsClassNameSuffix";


}
