/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.index.impl.lucene.RelationshipId;

class CommitContext {
    final LuceneDataSource dataSource;
    final IndexIdentifier identifier;
    final IndexType indexType;
    final Map<Long, DocumentContext> documents = new HashMap<Long, DocumentContext>();
    final LuceneTransaction.CommandList commandList;
    final boolean recovery;
    IndexWriter writer;
    IndexSearcher searcher;

    CommitContext(LuceneDataSource dataSource, IndexIdentifier identifier, IndexType indexType, LuceneTransaction.CommandList commandList) {
        this.dataSource = dataSource;
        this.identifier = identifier;
        this.indexType = indexType;
        this.commandList = commandList;
        this.recovery = commandList.isRecovery();
    }

    void ensureWriterInstantiated() {
        if (this.writer == null) {
            this.writer = this.dataSource.getIndexWriter(this.identifier);
            this.searcher = this.dataSource.getIndexSearcher(this.identifier, false).getSearcher();
        }
    }

    DocumentContext getDocument(Object entityId, boolean allowCreate) {
        long id = entityId instanceof Long ? (Long)entityId : ((RelationshipId)entityId).id;
        DocumentContext context = this.documents.get(id);
        if (context != null) {
            return context;
        }
        Document document = LuceneDataSource.findDocument(this.indexType, this.searcher, id);
        if (document != null) {
            context = new DocumentContext(document, true, id);
            this.documents.put(id, context);
        } else if (allowCreate) {
            context = new DocumentContext(this.identifier.entityType.newDocument(entityId), false, id);
            this.documents.put(id, context);
        }
        return context;
    }

    static class DocumentContext {
        final Document document;
        final boolean exists;
        final long entityId;

        DocumentContext(Document document, boolean exists, long entityId) {
            this.document = document;
            this.exists = exists;
            this.entityId = entityId;
        }
    }
}

