/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.garbage.GarbageBufferReference;
import org.nd4j.jita.allocator.pointers.cuda.cudaEvent_t;
import org.nd4j.jita.allocator.time.TimeProvider;
import org.nd4j.jita.allocator.time.providers.OperativeProvider;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationPoint {
    private static Logger log = LoggerFactory.getLogger(AllocationPoint.class);
    private OpaqueDataBuffer ptrDataBuffer;
    private Long objectId;
    private Long bucketId;
    private boolean isAttached = false;
    private volatile boolean released = false;
    private AllocationStatus allocationStatus = AllocationStatus.UNDEFINED;
    private transient TimeProvider timeProvider = new OperativeProvider();
    private long accessHostRead = 0L;
    private long accessDeviceRead = 0L;
    private long accessHostWrite = 0L;
    private long accessDeviceWrite = 0L;
    protected static final NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private boolean constant;
    private volatile int deviceId;
    private long bytes;
    private AtomicBoolean enqueued = new AtomicBoolean(false);
    private cudaEvent_t lastWriteEvent;
    private cudaEvent_t lastReadEvent;
    private volatile CudaContext currentContext;

    public AllocationPoint(@NonNull OpaqueDataBuffer opaqueDataBuffer, long bytes) {
        if (opaqueDataBuffer == null) {
            throw new NullPointerException("opaqueDataBuffer is marked non-null but is null");
        }
        this.ptrDataBuffer = opaqueDataBuffer;
        this.bytes = bytes;
        this.objectId = Nd4j.getDeallocatorService().nextValue();
    }

    public void setPointers(Pointer primary, Pointer special, long numberOfElements) {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSetPrimaryBuffer(this.ptrDataBuffer, primary, numberOfElements);
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSetSpecialBuffer(this.ptrDataBuffer, special, numberOfElements);
    }

    public int getDeviceId() {
        return this.ptrDataBuffer.deviceId();
    }

    public void setDeviceId(int deviceId) {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSetDeviceId(this.ptrDataBuffer, deviceId);
    }

    public boolean isEnqueued() {
        return this.enqueued.get();
    }

    public void markEnqueued(boolean reallyEnqueued) {
        this.enqueued.set(reallyEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaContext getCurrentContext() {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            return this.currentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentContext(CudaContext context) {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            this.currentContext = context;
        }
    }

    public long getNumberOfBytes() {
        return this.bytes;
    }

    public void attachBuffer(@NonNull BaseDataBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
    }

    public void attachReference(GarbageBufferReference reference) {
    }

    public DataBuffer getBuffer() {
        return null;
    }

    public AllocationStatus getAllocationStatus() {
        return this.allocationStatus;
    }

    public void setAllocationStatus(@NonNull AllocationStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.allocationStatus = status;
    }

    public Pointer getDevicePointer() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbSpecialBuffer(this.ptrDataBuffer);
    }

    public Pointer getHostPointer() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbPrimaryBuffer(this.ptrDataBuffer);
    }

    public synchronized void tickDeviceRead() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbTickDeviceRead(this.ptrDataBuffer);
    }

    public synchronized long getDeviceAccessTime() {
        return this.accessDeviceRead;
    }

    public synchronized long getDeviceWriteTime() {
        return this.accessDeviceWrite;
    }

    public synchronized void tickHostRead() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbTickHostRead(this.ptrDataBuffer);
    }

    public synchronized void tickDeviceWrite() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbTickDeviceWrite(this.ptrDataBuffer);
    }

    public synchronized void tickHostWrite() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbTickHostWrite(this.ptrDataBuffer);
    }

    public synchronized boolean isActualOnHostSide() {
        int s = NativeOpsHolder.getInstance().getDeviceNativeOps().dbLocality(this.ptrDataBuffer);
        return s <= 0;
    }

    public synchronized boolean isActualOnDeviceSide() {
        int s = NativeOpsHolder.getInstance().getDeviceNativeOps().dbLocality(this.ptrDataBuffer);
        return s >= 0;
    }

    public synchronized void tickDeviceToHost() {
        this.accessDeviceRead = this.accessHostRead;
    }

    public String toString() {
        return "AllocationPoint{deviceId=" + this.deviceId + ", objectId=" + this.objectId + "}";
    }

    public OpaqueDataBuffer getPtrDataBuffer() {
        return this.ptrDataBuffer;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Long getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Long bucketId) {
        this.bucketId = bucketId;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void setAttached(boolean isAttached) {
        this.isAttached = isAttached;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public cudaEvent_t getLastWriteEvent() {
        return this.lastWriteEvent;
    }

    public void setLastWriteEvent(cudaEvent_t lastWriteEvent) {
        this.lastWriteEvent = lastWriteEvent;
    }

    public cudaEvent_t getLastReadEvent() {
        return this.lastReadEvent;
    }

    public void setLastReadEvent(cudaEvent_t lastReadEvent) {
        this.lastReadEvent = lastReadEvent;
    }
}

