/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.AbstractJob;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduledDispatchJob
extends AbstractJob
implements Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ScheduledDispatchJobConfig config;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object payload = jobDataMap.get((Object)"payload");
        if (payload == null) {
            payload = NullPayload.getInstance();
        }
        if ((config = (ScheduledDispatchJobConfig)jobDataMap.get((Object)"jobConfig")) == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobConfig").getMessage());
        }
        try {
            String endpointRef = config.getEndpointRef();
            if (jobDataMap.containsKey((Object)"endpointRef")) {
                endpointRef = (String)jobDataMap.get((Object)"endpointRef");
            }
            this.logger.debug((Object)("Dispatching payload on: " + config.getEndpointRef()));
            MuleClient client = new MuleClient(this.muleContext);
            client.dispatch(endpointRef, payload, (Map)jobDataMap);
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

