/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageAdapter;
import org.mule.transport.jms.MessageRedeliveredException;
import org.mule.transport.jms.RedeliveryHandler;
import org.mule.transport.jms.i18n.JmsMessages;

public class JmsXRedeliveryHandler
implements RedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(JmsXRedeliveryHandler.class);
    protected JmsConnector connector;

    public void setConnector(JmsConnector connector) {
        this.connector = connector;
    }

    public void handleRedelivery(Message message) throws JMSException, MessagingException {
        if (this.connector.getMaxRedelivery() <= 0) {
            return;
        }
        String messageId = message.getJMSMessageID();
        int deliveryCount = -1;
        try {
            deliveryCount = message.getIntProperty("JMSXDeliveryCount");
        }
        catch (NumberFormatException nex) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Invalid use of %s. Message is flagged with JMSRedelivered, but JMSXDeliveryCount is not set", this.getClass().getName())));
        }
        int redeliveryCount = deliveryCount - 1;
        if (redeliveryCount == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered for the first time"));
            }
        } else {
            if (redeliveryCount > this.connector.getMaxRedelivery()) {
                logger.debug((Object)MessageFormat.format("Message with id: {0} has been redelivered {1} times, which exceeds the maxRedelivery setting of {2} on the connector {3}", messageId, redeliveryCount, this.connector.getMaxRedelivery(), this.connector.getName()));
                JmsMessageAdapter adapter = (JmsMessageAdapter)this.connector.getMessageAdapter(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(messageId, String.valueOf(redeliveryCount), this.connector.getMaxRedelivery(), this.connector.getName()), adapter);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

