/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transport.jms.i18n.JmsMessages;

public class JmsClientAcknowledgeTransaction
extends AbstractSingleResourceTransaction {
    private volatile Message message;

    public void setMessage(Message message) {
        this.message = message;
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            if (this.message == null) {
                throw new IllegalTransactionStateException(JmsMessages.noMessageBoundForAck());
            }
            this.message.acknowledge();
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        if (this.message != null) {
            throw new UnsupportedOperationException("Jms Client Acknowledge doesn't support rollback");
        }
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key instanceof Message) {
            this.message = (Message)key;
            return;
        }
        if (!(key instanceof Connection) || !(resource instanceof Session)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"javax.jms.Connection/javax.jms.Session"));
        }
        Session session = (Session)resource;
        try {
            if (session.getTransacted()) {
                throw new IllegalTransactionStateException(JmsMessages.sessionShouldNotBeTransacted());
            }
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotReadState(), (Throwable)e);
        }
        super.bindResource(key, resource);
    }
}

