/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.mule.api.MuleEvent;
import org.mule.transport.http.CookieHelper;

enum CookieStorageType {
    ARRAY_OF_COOKIES{

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, String cookieName, String cookieValue) {
            Cookie[] mergedCookiesArray;
            Cookie[] preExistentCookiesArray = (Cookie[])preExistentCookies;
            int sessionIndex = this.getCookieIndexFromCookiesArray(cookieName, preExistentCookiesArray);
            Cookie newSessionCookie = new Cookie(null, cookieName, cookieValue);
            if (sessionIndex >= 0) {
                preExistentCookiesArray[sessionIndex] = newSessionCookie;
                mergedCookiesArray = preExistentCookiesArray;
            } else {
                Cookie[] newSessionCookieArray = new Cookie[]{newSessionCookie};
                mergedCookiesArray = this.concatenateCookies(preExistentCookiesArray, newSessionCookieArray);
            }
            return mergedCookiesArray;
        }

        protected Cookie[] concatenateCookies(Cookie[] cookies1, Cookie[] cookies2) {
            if (cookies1 == null) {
                return cookies2;
            }
            if (cookies2 == null) {
                return null;
            }
            Cookie[] mergedCookies = new Cookie[cookies1.length + cookies2.length];
            System.arraycopy(cookies1, 0, mergedCookies, 0, cookies1.length);
            System.arraycopy(cookies2, 0, mergedCookies, cookies1.length, cookies2.length);
            return mergedCookies;
        }

        protected int getCookieIndexFromCookiesArray(String cookieName, Cookie[] preExistentCookies) {
            if (preExistentCookies != null && cookieName != null) {
                for (int i = 0; i < preExistentCookies.length; ++i) {
                    if (!cookieName.equals(preExistentCookies[i].getName())) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public String getCookieValueFromCookies(Object cookiesObject, String cookieName) {
            Cookie[] cookies = (Cookie[])cookiesObject;
            int sessionIndex = this.getCookieIndexFromCookiesArray(cookieName, cookies);
            if (sessionIndex >= 0) {
                return cookies[sessionIndex].getValue();
            }
            return null;
        }

        @Override
        public void addCookiesToClient(HttpClient client, Object cookiesObject, String policy, MuleEvent event, URI destinationUri) {
            Cookie[] cookies = (Cookie[])cookiesObject;
            if (cookies != null && cookies.length > 0) {
                String host = destinationUri.getHost();
                String path = destinationUri.getPath();
                for (Cookie cookie : cookies) {
                    client.getState().addCookie(new Cookie(host, cookie.getName(), cookie.getValue(), path, cookie.getExpiryDate(), cookie.getSecure()));
                }
                client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
            }
        }

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, Cookie[] newCookiesArray) {
            if (newCookiesArray == null) {
                return preExistentCookies;
            }
            ArrayList<Cookie> cookiesThatAreReallyNew = new ArrayList<Cookie>(newCookiesArray.length);
            Cookie[] preExistentCookiesArray = (Cookie[])preExistentCookies;
            for (Cookie newCookie : newCookiesArray) {
                int newCookieInPreExistentArrayIndex = this.getCookieIndexFromCookiesArray(newCookie.getName(), preExistentCookiesArray);
                if (newCookieInPreExistentArrayIndex >= 0) {
                    preExistentCookiesArray[newCookieInPreExistentArrayIndex] = newCookie;
                    continue;
                }
                cookiesThatAreReallyNew.add(newCookie);
            }
            return this.concatenateCookies(preExistentCookiesArray, cookiesThatAreReallyNew.toArray(new Cookie[cookiesThatAreReallyNew.size()]));
        }

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, Map<String, String> newCookiesMap) {
            if (newCookiesMap == null) {
                return this.putAndMergeCookie(preExistentCookies, (Cookie[])null);
            }
            Cookie[] cookiesArray = new Cookie[newCookiesMap.size()];
            int i = 0;
            for (Map.Entry<String, String> cookieEntry : newCookiesMap.entrySet()) {
                Cookie cookie = new Cookie();
                cookie.setName(cookieEntry.getKey());
                cookie.setValue(cookieEntry.getValue());
                cookiesArray[i++] = cookie;
            }
            return this.putAndMergeCookie(preExistentCookies, cookiesArray);
        }

        @Override
        public Cookie[] asArrayOfCookies(Object cookiesObject) {
            if (cookiesObject == null) {
                return ZERO_COOKIES;
            }
            return (Cookie[])cookiesObject;
        }
    }
    ,
    MAP_STRING_STRING{

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, String cookieName, String cookieValue) {
            Map cookieMap = (Map)preExistentCookies;
            cookieMap.put(cookieName, cookieValue);
            return cookieMap;
        }

        @Override
        public String getCookieValueFromCookies(Object cookiesObject, String cookieName) {
            return (String)((Map)cookiesObject).get(cookieName);
        }

        @Override
        public void addCookiesToClient(HttpClient client, Object cookiesObject, String policy, MuleEvent event, URI destinationUri) {
            Map cookieMap = (Map)cookiesObject;
            client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
            String host = destinationUri.getHost();
            String path = destinationUri.getPath();
            for (String key : cookieMap.keySet()) {
                String cookieValue = (String)cookieMap.get(key);
                String value = event != null ? event.getMuleContext().getExpressionManager().parse(cookieValue, event.getMessage()) : cookieValue;
                Cookie cookie = new Cookie(host, key, value, path, null, false);
                client.getState().addCookie(cookie);
            }
        }

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, Cookie[] newCookiesArray) {
            if (newCookiesArray == null) {
                return preExistentCookies;
            }
            for (Cookie cookie : newCookiesArray) {
                preExistentCookies = this.putAndMergeCookie(preExistentCookies, cookie.getName(), cookie.getValue());
            }
            return preExistentCookies;
        }

        @Override
        public Object putAndMergeCookie(Object preExistentCookies, Map<String, String> newCookiesMap) {
            if (newCookiesMap == null) {
                return preExistentCookies;
            }
            for (Map.Entry<String, String> cookieEntry : newCookiesMap.entrySet()) {
                preExistentCookies = this.putAndMergeCookie(preExistentCookies, cookieEntry.getKey(), cookieEntry.getValue());
            }
            return preExistentCookies;
        }

        @Override
        public Cookie[] asArrayOfCookies(Object cookiesObject) {
            Map cookieMap = (Map)cookiesObject;
            Cookie[] arrayOfCookies = new Cookie[cookieMap.size()];
            int i = 0;
            for (Map.Entry cookieEntry : cookieMap.entrySet()) {
                Cookie cookie = new Cookie();
                cookie.setName((String)cookieEntry.getKey());
                cookie.setValue((String)cookieEntry.getValue());
                arrayOfCookies[i++] = cookie;
            }
            return arrayOfCookies;
        }
    };

    private static final Cookie[] ZERO_COOKIES;

    public static CookieStorageType resolveCookieStorageType(Object cookiesObject) {
        if (cookiesObject == null || cookiesObject instanceof Cookie[]) {
            return ARRAY_OF_COOKIES;
        }
        if (cookiesObject instanceof Map) {
            return MAP_STRING_STRING;
        }
        throw new IllegalArgumentException("Invalid cookiesObject. Only " + Cookie.class + "[] and " + Map.class + " are supported: " + cookiesObject);
    }

    public abstract Object putAndMergeCookie(Object var1, String var2, String var3);

    public abstract Object putAndMergeCookie(Object var1, Cookie[] var2);

    public abstract Object putAndMergeCookie(Object var1, Map<String, String> var2);

    public abstract String getCookieValueFromCookies(Object var1, String var2);

    public abstract void addCookiesToClient(HttpClient var1, Object var2, String var3, MuleEvent var4, URI var5);

    public abstract Cookie[] asArrayOfCookies(Object var1);

    static {
        ZERO_COOKIES = new Cookie[0];
    }
}

