/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.NullPayload;
import org.mule.transport.http.ReleasingInputStream;

public class HttpClientMethodResponseToObject
extends AbstractTransformer {
    public HttpClientMethodResponseToObject() {
        this.registerSourceType(HttpMethod.class);
        this.setReturnClass(MuleMessage.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        InputStream is;
        HttpMethod httpMethod = (HttpMethod)src;
        try {
            is = httpMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        Object msg = is == null ? NullPayload.getInstance() : new ReleasingInputStream(is, httpMethod);
        HashMap<String, String> headerProps = new HashMap<String, String>();
        Header[] headers = httpMethod.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String name = headers[i].getName();
            if (name.startsWith("X-MULE_")) {
                name = name.substring(2);
            }
            headerProps.put(name, headers[i].getValue());
        }
        return new DefaultMuleMessage(msg, headerProps);
    }
}

