/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleServer;
import org.mule.NullSessionHandler;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.SessionHandler;
import org.mule.transport.ConnectException;
import org.mule.transport.NullPayload;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpMessageReceiver;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;
import org.mule.util.monitor.Expirable;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public HttpMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    protected void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer(80);
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(this.endpoint.getEndpointURI().getPort());
        requestUri.append('*');
        MessageReceiver[] receivers = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < receivers.length; ++i) {
            if (!receivers[i].isConnected()) continue;
            return false;
        }
        return true;
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setProperty("http.status", (Object)String.valueOf(406));
        return message;
    }

    protected MessageReceiver getTargetReceiver(MuleMessage message, ImmutableEndpoint endpoint) throws ConnectException {
        MessageReceiver receiver;
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer(80);
        if (path.indexOf("://") == -1) {
            requestUri.append(endpoint.getProtocol()).append("://");
            requestUri.append(endpoint.getEndpointURI().getHost());
            requestUri.append(':').append(endpoint.getEndpointURI().getPort());
            if (!"/".equals(path)) {
                requestUri.append(path);
            }
        }
        String uriStr = requestUri.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.lookupReceiver(uriStr)) == null && !"/".equals(path)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if (receiver == null) {
                receiver = HttpMessageReceiver.findReceiverByStem(this.connector.getReceivers(), uriStr);
            }
            if (receiver == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString((Map)this.connector.getReceivers(), (boolean)true)));
            }
        }
        return receiver;
    }

    protected HttpResponse transformResponse(Object response) throws TransformerException {
        Object message = response instanceof MuleMessage ? (MuleMessage)response : new DefaultMuleMessage(response);
        message.applyTransformers(this.connector.getDefaultResponseTransformers(), HttpResponse.class);
        return (HttpResponse)message.getPayload();
    }

    public static MessageReceiver findReceiverByStem(Map receivers, String uriStr) {
        int match = 0;
        MessageReceiver receiver = null;
        for (Map.Entry e : receivers.entrySet()) {
            String key = (String)e.getKey();
            MessageReceiver candidate = (MessageReceiver)e.getValue();
            if (!uriStr.startsWith(key) || match >= key.length()) continue;
            match = key.length();
            receiver = candidate;
        }
        return receiver;
    }

    protected class HttpWorker
    implements Work,
    Expirable {
        private HttpServerConnection conn;
        private String cookieSpec;
        private boolean enableCookies;
        private String remoteClientAddress;

        public HttpWorker(Socket socket) throws IOException {
            String encoding = HttpMessageReceiver.this.endpoint.getEncoding();
            if (encoding == null) {
                encoding = MuleServer.getMuleContext().getConfiguration().getDefaultEncoding();
            }
            this.conn = new HttpServerConnection(socket, encoding, (HttpConnector)HttpMessageReceiver.this.connector);
            this.cookieSpec = MapUtils.getString((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)HttpMessageReceiver.this.connector).getCookieSpec());
            this.enableCookies = MapUtils.getBooleanValue((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)HttpMessageReceiver.this.connector).isEnableCookies());
            SocketAddress clientAddress = socket.getRemoteSocketAddress();
            if (clientAddress != null) {
                this.remoteClientAddress = clientAddress.toString();
            }
        }

        public void expired() {
            if (this.conn.isOpen()) {
                this.conn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long keepAliveTimeout = ((TcpConnector)HttpMessageReceiver.this.connector).getKeepAliveTimeout();
            try {
                do {
                    HttpRequest request;
                    this.conn.setKeepAlive(false);
                    if (keepAliveTimeout > 0L) {
                        ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().addExpirable(keepAliveTimeout, TimeUnit.MILLISECONDS, (Expirable)this);
                    }
                    if ((request = this.conn.readRequest()) == null) {
                        break;
                    }
                    ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable((Expirable)this);
                    this.conn.writeResponse(this.processRequest(request));
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                HttpMessageReceiver.this.logger.debug((Object)"Closing HTTP connection.");
                if (this.conn.isOpen()) {
                    this.conn.close();
                    this.conn = null;
                    ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable((Expirable)this);
                }
            }
        }

        protected HttpResponse processRequest(HttpRequest request) throws MuleException, IOException {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            if (method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT")) {
                return this.doRequest(request, requestLine);
            }
            return this.doBad(requestLine);
        }

        protected HttpResponse doRequest(HttpRequest request, RequestLine requestLine) throws IOException, MuleException {
            HttpResponse response;
            Map headers = this.parseHeaders(request);
            MessageAdapter adapter = this.buildStandardAdapter(request, headers);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)adapter);
            String path = (String)message.getProperty("http.request");
            int i = path.indexOf(63);
            if (i > -1) {
                path = path.substring(0, i);
            }
            message.setProperty("http.request.path", (Object)path);
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug(message.getProperty("http.request"));
            }
            message.setProperty("http.context.path", (Object)HttpConnector.normalizeUrl(HttpMessageReceiver.this.endpoint.getEndpointURI().getPath()));
            MessageReceiver receiver = HttpMessageReceiver.this.getTargetReceiver((MuleMessage)message, HttpMessageReceiver.this.endpoint);
            if (receiver != null) {
                this.preRouteMessage((MuleMessage)message);
                MuleMessage returnMessage = receiver.routeMessage((MuleMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), null);
                Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
                response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : HttpMessageReceiver.this.transformResponse(returnMessage);
                response.disableKeepAlive(!((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive());
                boolean endpointOverride = Boolean.parseBoolean((String)HttpMessageReceiver.this.endpoint.getProperty((Object)"keepAlive"));
                Header connectionHeader = request.getFirstHeader("Connection");
                if (connectionHeader != null) {
                    String value = connectionHeader.getValue();
                    if ("keep-alive".equalsIgnoreCase(value) && !endpointOverride) {
                        response.setKeepAlive(true);
                        Header header = new Header("Keep-Alive", "timeout=" + ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveTimeout());
                        response.addHeader(header);
                    } else if ("close".equalsIgnoreCase(value)) {
                        response.setKeepAlive(false);
                    } else if (response.getHttpVersion().greaterEquals(HttpVersion.HTTP_1_1)) {
                        response.setKeepAlive(true);
                    } else {
                        response.setKeepAlive(false);
                    }
                }
            } else {
                response = this.buildFailureResponse(requestLine, (MuleMessage)message);
            }
            return response;
        }

        protected HttpResponse doOtherValid(RequestLine requestLine, String method) throws MuleException {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)NullPayload.getInstance());
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession((MuleMessage)message, (SessionHandler)new NullSessionHandler(), HttpMessageReceiver.this.connector.getMuleContext()), true);
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 405);
            response.setBody(HttpMessages.methodNotAllowed(method).toString() + "\r\n");
            return HttpMessageReceiver.this.transformResponse(response);
        }

        protected HttpResponse doBad(RequestLine requestLine) throws MuleException {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)NullPayload.getInstance());
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession((MuleMessage)message, (SessionHandler)new NullSessionHandler(), HttpMessageReceiver.this.connector.getMuleContext()), true);
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 400);
            response.setBody(HttpMessages.malformedSyntax().toString() + "\r\n");
            return HttpMessageReceiver.this.transformResponse(response);
        }

        protected MessageAdapter buildStandardAdapter(HttpRequest request, Map headers) throws MessagingException, TransformerException, IOException {
            RequestLine requestLine = request.getRequestLine();
            this.sendExpect100(headers, requestLine);
            Object body = request.getBody();
            if (body == null) {
                body = requestLine.getUri();
            }
            return HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{body, headers});
        }

        private void sendExpect100(Map headers, RequestLine requestLine) throws TransformerException, IOException {
            String expectHeaderValue;
            if ("HTTP/1.1".equals(headers.get("http.version")) && "100-continue".equals(expectHeaderValue = ObjectUtils.toString(headers.get("Expect")).toLowerCase())) {
                HttpResponse expected = new HttpResponse();
                expected.setStatusLine(requestLine.getHttpVersion(), 100);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)expected), HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.service, HttpMessageReceiver.this.connector.getMuleContext()), true);
                RequestContext.setEvent((MuleEvent)event);
                this.conn.writeResponse(HttpMessageReceiver.this.transformResponse(expected));
            }
        }

        protected HttpResponse buildFailureResponse(RequestLine requestLine, MuleMessage message) throws TransformerException {
            EndpointURI uri = HttpMessageReceiver.this.endpoint.getEndpointURI();
            String failedPath = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + message.getProperty("http.request.path");
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
            }
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 404);
            response.setBody(HttpMessages.cannotBindToAddress(failedPath).toString());
            RequestContext.setEvent((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)response), HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.service, HttpMessageReceiver.this.connector.getMuleContext()), true));
            return HttpMessageReceiver.this.transformResponse(response);
        }

        protected Map parseHeaders(HttpRequest request) throws MalformedCookieException {
            RequestLine requestLine = request.getRequestLine();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            Iterator rhi = request.getHeaderIterator();
            while (rhi.hasNext()) {
                Header header = (Header)rhi.next();
                String headerName = header.getName();
                Cookie[] headerValue = header.getValue();
                if (headerName.startsWith("X-MULE")) {
                    headerName = headerName.substring(2);
                } else if (headerName.equals("cookies")) {
                    Cookie[] cookies;
                    if (!this.enableCookies || (cookies = CookieHelper.parseCookies(header, this.cookieSpec)).length <= 0) continue;
                    headerValue = cookies;
                }
                headers.put(headerName, headerValue);
            }
            headers.put("http.method", requestLine.getMethod());
            headers.put("http.request", requestLine.getUri());
            headers.put("http.version", requestLine.getHttpVersion().toString());
            headers.put("cookieSpec", this.cookieSpec);
            return headers;
        }

        protected void preRouteMessage(MuleMessage message) {
            message.setProperty("MULE_REMOTE_CLIENT_ADDRESS", (Object)this.remoteClientAddress);
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

