/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.file.FilenameParser;
import org.mule.util.DateUtils;
import org.mule.util.TemplateParser;
import org.mule.util.UUID;

@Deprecated
public class SimpleFilenameParser
implements FilenameParser {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_DATE_FORMAT = "dd-MM-yy_HH-mm-ss.SSS";
    private final TemplateParser wigglyMuleParser = TemplateParser.createMuleStyleParser();
    private final TemplateParser antParser = TemplateParser.createAntStyleParser();
    private final TemplateParser squareParser = TemplateParser.createSquareBracesStyleParser();
    private final AtomicLong count = new AtomicLong(0L);

    public String getFilename(MessageAdapter adapter, String pattern) {
        if (pattern == null) {
            return UUID.getUUID() + ".dat";
        }
        if (pattern.contains("#[")) {
            return this.getFilename(adapter, pattern, this.wigglyMuleParser);
        }
        if (pattern.contains("{")) {
            this.logger.warn((Object)("Found " + pattern + ". Using ${} style has been deprecated for Mule placeholders and won't be supported in the future," + " please switch to #[] and ExpressionFilenameParser"));
            return this.getFilename(adapter, pattern, this.antParser);
        }
        return this.getFilename(adapter, pattern, this.squareParser);
    }

    protected String getFilename(final MessageAdapter adapter, String pattern, TemplateParser parser) {
        return parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                if (token.equals("DATE")) {
                    return DateUtils.getTimeStamp((String)SimpleFilenameParser.DEFAULT_DATE_FORMAT);
                }
                if (token.startsWith("DATE:")) {
                    token = token.substring(5);
                    return DateUtils.getTimeStamp((String)token);
                }
                if (token.startsWith("UUID")) {
                    return UUID.getUUID();
                }
                if (token.startsWith("SYSTIME")) {
                    return String.valueOf(System.currentTimeMillis());
                }
                if (token.startsWith("COUNT")) {
                    return String.valueOf(SimpleFilenameParser.this.count.getAndIncrement());
                }
                if (adapter != null) {
                    if (token.startsWith("ORIGINALNAME")) {
                        return adapter.getStringProperty("originalFilename", null);
                    }
                    return adapter.getStringProperty(token, null);
                }
                return null;
            }
        }, pattern);
    }
}

