/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import org.apache.commons.lang.BooleanUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.DispatchException;
import org.mule.transport.cxf.i18n.CxfMessages;
import org.mule.transport.cxf.support.CopyAttachmentInInterceptor;
import org.mule.transport.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.transport.cxf.support.MuleHeadersInInterceptor;
import org.mule.transport.cxf.support.MuleHeadersOutInterceptor;
import org.mule.transport.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.transport.cxf.support.OutputPayloadInterceptor;
import org.mule.transport.cxf.support.ProxyService;
import org.mule.transport.cxf.support.StreamClosingInterceptor;
import org.mule.transport.cxf.transport.MuleUniversalConduit;
import org.mule.transport.soap.i18n.SoapMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientWrapper {
    protected ImmutableEndpoint endpoint;
    protected Bus bus;
    protected Client client;
    protected String defaultMethodName;
    protected BindingProvider clientProxy;
    protected Method defaultMethod;
    protected boolean proxy;
    private boolean applyTransformersToProtocol;
    private boolean enableHeaders;

    public Client getClient() {
        return this.client;
    }

    public BindingProvider getClientProxy() {
        return this.clientProxy;
    }

    public void initialize() throws Exception {
        String clientClass = (String)this.endpoint.getProperty((Object)"clientClass");
        this.proxy = BooleanUtils.toBoolean((String)((String)this.endpoint.getProperty((Object)"proxy")));
        if (clientClass != null) {
            this.createClientFromClass(this.bus, clientClass);
        } else if (this.proxy) {
            this.createClientProxy(this.bus);
        } else {
            this.createClientFromLocalServer(this.bus);
        }
        this.addInterceptors(this.client.getInInterceptors(), (List)this.endpoint.getProperty((Object)"inInterceptors"));
        this.addInterceptors(this.client.getInFaultInterceptors(), (List)this.endpoint.getProperty((Object)"inFaultInterceptors"));
        this.addInterceptors(this.client.getOutInterceptors(), (List)this.endpoint.getProperty((Object)"outInterceptors"));
        this.addInterceptors(this.client.getOutFaultInterceptors(), (List)this.endpoint.getProperty((Object)"outFaultInterceptors"));
        MuleUniversalConduit conduit = (MuleUniversalConduit)this.client.getConduit();
        conduit.setMuleEndpoint(this.endpoint);
        if (this.proxy) {
            this.client.getInInterceptors().add(new CopyAttachmentInInterceptor());
            this.client.getInInterceptors().add(new StreamClosingInterceptor());
            this.client.getOutInterceptors().add(new OutputPayloadInterceptor());
            this.client.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
            conduit.setCloseInput(false);
        }
        String value = (String)this.endpoint.getProperty((Object)"applyTransformersToProtocol");
        this.applyTransformersToProtocol = this.isTrue(value, true);
        conduit.setApplyTransformersToProtocol(this.applyTransformersToProtocol);
        this.enableHeaders = this.isTrue((String)this.endpoint.getProperty((Object)"enableMuleSoapHeaders"), true);
        List features = (List)this.endpoint.getProperty((Object)"features");
        if (features != null) {
            for (AbstractFeature f : features) {
                f.initialize(this.client, this.bus);
            }
        }
        EndpointImpl ep = (EndpointImpl)this.client.getEndpoint();
        Object mtomEnabled = this.endpoint.getProperty((Object)"mtomEnabled");
        if (mtomEnabled != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("mtom-enabled", mtomEnabled);
            ep.setProperties(props);
        }
        this.addMuleInterceptors();
    }

    private boolean isTrue(String value, boolean def) {
        if (value == null) {
            return def;
        }
        return BooleanUtils.toBoolean((String)value);
    }

    private void addInterceptors(List<Interceptor> col, List<Interceptor> supplied) {
        if (supplied != null) {
            col.addAll(supplied);
        }
    }

    protected Method findMethod(Class<?> clientCls) throws Exception {
        if (this.defaultMethod == null) {
            String op = (String)this.endpoint.getProperties().get("operation");
            if (op == null) {
                op = (String)this.endpoint.getProperties().get("operation");
            }
            if (op != null) {
                return this.getMethodFromOperation(op);
            }
        }
        return null;
    }

    protected BindingOperationInfo getOperation(String opName) throws Exception {
        Endpoint ep = this.client.getEndpoint();
        QName q = new QName(ep.getService().getName().getNamespaceURI(), opName);
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        if (bop == null) {
            throw new Exception("No such operation: " + opName);
        }
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    private Method getMethodFromOperation(String op) throws Exception {
        BindingOperationInfo bop = this.getOperation(op);
        MethodDispatcher md = (MethodDispatcher)this.client.getEndpoint().getService().get((Object)MethodDispatcher.class.getName());
        return md.getMethod(bop);
    }

    protected void createClientProxy(Bus bus) throws Exception {
        String wsdlLocation = (String)this.endpoint.getProperty((Object)"wsdlLocation");
        ClientProxyFactoryBean cpf = new ClientProxyFactoryBean();
        cpf.setServiceClass(ProxyService.class);
        cpf.setDataBinding((DataBinding)new StaxDataBinding());
        cpf.getFeatures().add(new StaxDataBindingFeature());
        cpf.setAddress(this.endpoint.getEndpointURI().getAddress());
        cpf.setBus(bus);
        if (wsdlLocation != null) {
            cpf.setWsdlLocation(wsdlLocation);
        }
        this.client = ClientProxy.getClient((Object)cpf.create());
        Binding binding = this.client.getEndpoint().getBinding();
        this.removeInterceptor(binding.getOutInterceptors(), WrappedOutInterceptor.class.getName());
        this.proxy = true;
    }

    private void removeInterceptor(List<Interceptor> inInterceptors, String name) {
        for (Interceptor i : inInterceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getId().equals(name)) continue;
            inInterceptors.remove(p);
            return;
        }
    }

    protected void createClientFromClass(Bus bus, String clientClassName) throws Exception {
        String wsdlLocation = (String)this.endpoint.getProperty((Object)"wsdlLocation");
        Class clientCls = ClassLoaderUtils.loadClass((String)clientClassName, this.getClass());
        Service s = null;
        if (wsdlLocation != null) {
            Constructor cons = clientCls.getConstructor(URL.class, QName.class);
            ResourceManager rr = (ResourceManager)bus.getExtension(ResourceManager.class);
            URL url = (URL)rr.resolveResource(wsdlLocation, URL.class);
            if (url == null) {
                URIResolver res = new URIResolver(wsdlLocation);
                if (!res.isResolved()) {
                    throw new CreateException(CxfMessages.wsdlNotFound(wsdlLocation), (Object)this);
                }
                url = res.getURL();
            }
            WebServiceClient clientAnn = clientCls.getAnnotation(WebServiceClient.class);
            QName svcName = new QName(clientAnn.targetNamespace(), clientAnn.name());
            s = (Service)cons.newInstance(url, svcName);
        } else {
            s = (Service)clientCls.newInstance();
        }
        String port = (String)this.endpoint.getProperty((Object)"wsdlPort");
        if (port == null) {
            throw new CreateException(CxfMessages.mustSpecifyPort(), (Object)this);
        }
        this.clientProxy = null;
        if (port != null) {
            for (Method m : clientCls.getMethods()) {
                WebEndpoint we = m.getAnnotation(WebEndpoint.class);
                if (we == null || !we.name().equals(port) || m.getParameterTypes().length != 0) continue;
                this.clientProxy = (BindingProvider)m.invoke((Object)s, new Object[0]);
                break;
            }
        }
        if (this.clientProxy == null) {
            throw new CreateException(CxfMessages.portNotFound(port), (Object)this);
        }
        EndpointURI uri = this.endpoint.getEndpointURI();
        if (uri.getUser() != null) {
            this.clientProxy.getRequestContext().put("javax.xml.ws.security.auth.username", uri.getUser());
        }
        if (uri.getPassword() != null) {
            this.clientProxy.getRequestContext().put("javax.xml.ws.security.auth.password", uri.getPassword());
        }
        this.clientProxy.getRequestContext().put("javax.xml.ws.service.endpoint.address", uri.getAddress());
        this.client = ClientProxy.getClient((Object)this.clientProxy);
        this.defaultMethod = this.findMethod(clientCls);
        this.defaultMethodName = this.getDefaultMethodName();
    }

    private String getDefaultMethodName() {
        EndpointURI endpointUri = this.endpoint.getEndpointURI();
        String m = (String)endpointUri.getParams().get("method");
        if (m == null) {
            m = (String)this.endpoint.getProperties().get("method");
        }
        return m;
    }

    protected void createClientFromLocalServer(Bus bus) throws Exception {
        String uri = this.endpoint.getEndpointURI().toString();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactoryForUri(uri);
        if (df == null) {
            throw new Exception("Could not find a destination factory for uri " + uri);
        }
        Destination dest = df.getDestination(ei);
        MessageObserver mo = dest.getMessageObserver();
        if (!(mo instanceof ChainInitiationObserver)) {
            throw new Exception("Could not create client! No Server was found directly on the endpoint: " + uri);
        }
        ChainInitiationObserver cMo = (ChainInitiationObserver)mo;
        Endpoint cxfEP = cMo.getEndpoint();
        this.client = new ClientImpl(bus, cxfEP);
    }

    protected void addMuleInterceptors() {
        this.client.getInInterceptors().add(new MuleHeadersInInterceptor());
        this.client.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
        if (this.enableHeaders) {
            this.client.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            this.client.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
        this.client.getOutInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        this.client.getOutFaultInterceptors().add(new MuleProtocolHeadersOutInterceptor());
    }

    protected String getMethodOrOperationName(MuleEvent event) throws DispatchException {
        String method = (String)event.getMessage().getProperty("operation");
        if (method == null) {
            method = (String)event.getMessage().getProperty("method");
        }
        if (method == null) {
            method = this.defaultMethodName;
        }
        if (method == null && this.proxy) {
            return "invoke";
        }
        if (method == null) {
            throw new DispatchException(SoapMessages.cannotInvokeCallWithoutOperation(), event.getMessage(), event.getEndpoint());
        }
        return method;
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public boolean isClientProxyAvailable() {
        return this.clientProxy != null;
    }

    public BindingOperationInfo getOperation(MuleEvent event) throws Exception {
        String opName = this.getMethodOrOperationName(event);
        if (opName == null) {
            opName = this.defaultMethodName;
        }
        return this.getOperation(opName);
    }

    public Method getMethod(MuleEvent event) throws Exception {
        Method method = this.defaultMethod;
        if (method == null) {
            String opName = (String)event.getMessage().getProperty("operation");
            if (opName != null) {
                method = this.getMethodFromOperation(opName);
            }
            if (method == null && (opName = (String)this.endpoint.getProperty((Object)"operation")) != null) {
                method = this.getMethodFromOperation(opName);
            }
            if (method == null && (opName = this.defaultMethodName) != null) {
                method = this.getMethodFromOperation(opName);
            }
        }
        if (method == null) {
            throw new DispatchException(CxfMessages.noOperationWasFoundOrSpecified(), event.getMessage(), this.endpoint);
        }
        return method;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isApplyTransformersToProtocol() {
        return this.applyTransformersToProtocol;
    }
}

