/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.processors;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.AnnotationException;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MessageProcessorAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.annotations.meta.ChannelType;
import org.mule.api.annotations.meta.Router;
import org.mule.api.annotations.meta.RouterType;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.PreInitProcessor;
import org.mule.api.registry.Registry;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.AnnotationsParserFactory;
import org.mule.config.endpoint.AnnotatedEndpointHelper;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.config.i18n.CoreMessages;
import org.mule.registry.RegistryMap;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.util.TemplateParser;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class DecoratingAnnotatedServiceProcessor
implements PreInitProcessor,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(DecoratingAnnotatedServiceProcessor.class);
    protected MuleContext context;
    private final TemplateParser parser = TemplateParser.createAntStyleParser();
    protected RegistryMap regProps;
    protected AnnotatedEndpointHelper helper;
    protected AnnotationsParserFactory parserFactory;

    public DecoratingAnnotatedServiceProcessor() {
    }

    public DecoratingAnnotatedServiceProcessor(MuleContext context) {
        this.setMuleContext(context);
    }

    public void setMuleContext(MuleContext context) {
        try {
            this.context = context;
            this.regProps = new RegistryMap((Registry)context.getRegistry());
            this.helper = new AnnotatedEndpointHelper(context);
            this.parserFactory = (AnnotationsParserFactory)context.getRegistry().lookupObject(AnnotationsParserFactory.class);
            if (this.parserFactory == null) {
                this.logger.info((Object)(AnnotationsParserFactory.class.getName() + " implementation not found in registry, annotations not enabled"));
            }
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate((String)this.getClass().getName()), (Throwable)e);
        }
    }

    public Object process(Object object) {
        Service service;
        if (object == null || this.parserFactory == null) {
            return object;
        }
        if (object instanceof Service && (service = (Service)object).getComponent() instanceof AbstractJavaComponent) {
            try {
                AbstractJavaComponent component = (AbstractJavaComponent)service.getComponent();
                if (AnnotationUtils.getMethodMetaAnnotations((Class)component.getObjectType(), Channel.class).size() == 0) {
                    return object;
                }
                this.processInbound(component.getObjectType(), service);
                this.processOutbound(component.getObjectType(), service);
                this.processReply(component.getObjectType(), service);
            }
            catch (MuleException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    protected void processInbound(Class componentFactoryClass, Service service) throws MuleException {
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(annotation, ChannelType.Inbound);
            if (inboundEndpoint == null) continue;
            if (annotation.getType() == ElementType.METHOD) {
                inboundEndpoint.getProperties().put("method", annotation.getElementName());
            }
            ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)inboundEndpoint);
        }
        this.processInboundRouters(componentFactoryClass, service);
    }

    protected void processInboundRouters(Class componentFactoryClass, Service service) throws MuleException {
        for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            Router routerAnnotation = annotation.annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Inbound) continue;
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(annotation, componentFactoryClass, null);
            if (parser != null) {
                ((ServiceCompositeMessageSource)service.getMessageSource()).addMessageProcessor(parser.parseMessageProcessor(annotation));
                continue;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)annotation).toString());
        }
    }

    protected void processReplyRouters(Class componentFactoryClass, Service service) throws MuleException {
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.ReplyTo) continue;
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser != null) {
                MessageProcessor router = parser.parseMessageProcessor(metaData.getAnnotation());
                if (router instanceof MuleContextAware) {
                    ((MuleContextAware)router).setMuleContext(this.context);
                }
                if (!(router instanceof Initialisable)) break;
                ((Initialisable)router).initialise();
                break;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)metaData.getAnnotation()).toString());
        }
    }

    protected OutboundRouter processOutboundRouter(Class componentFactoryClass) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(MessageProcessorAnnotationParser.class);
        OutboundPassThroughRouter router = null;
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Outbound) continue;
            if (router != null) {
                throw new IllegalStateException("You can only configure one outbound router on a service");
            }
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser != null) {
                router = (OutboundRouter)parser.parseMessageProcessor(metaData.getAnnotation());
                continue;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)metaData.getAnnotation()).toString());
        }
        if (router == null) {
            router = new OutboundPassThroughRouter();
        }
        if (router instanceof MuleContextAware) {
            router.setMuleContext(this.context);
        }
        router.initialise();
        return router;
    }

    protected void processOutbound(Class componentFactoryClass, Service service) throws MuleException {
        OutboundRouter router = this.processOutboundRouter(componentFactoryClass);
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            OutboundEndpoint outboundEndpoint = this.tryOutboundEndpointAnnotation(annotation, ChannelType.Outbound);
            if (outboundEndpoint == null) continue;
            router.addRoute((MessageProcessor)outboundEndpoint);
        }
        if (router instanceof MuleContextAware) {
            router.setMuleContext(this.context);
        }
        router.initialise();
        ((OutboundRouterCollection)service.getOutboundMessageProcessor()).addRoute((MatchableMessageProcessor)router);
    }

    protected InboundEndpoint tryInboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            EndpointAnnotationParser parser = this.parserFactory.getEndpointParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser == null) {
                throw new AnnotationException(AnnotationsMessages.createStaticMessage((String)("No parser found for annotation: " + metaData)));
            }
            return parser.parseInboundEndpoint(metaData.getAnnotation(), Collections.EMPTY_MAP);
        }
        return null;
    }

    protected OutboundEndpoint tryOutboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            EndpointAnnotationParser parser = this.parserFactory.getEndpointParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser == null) {
                throw new AnnotationException(AnnotationsMessages.createStaticMessage((String)("No parser found for annotation: " + metaData)));
            }
            return parser.parseOutboundEndpoint(metaData.getAnnotation(), Collections.EMPTY_MAP);
        }
        return null;
    }

    protected void processReply(Class componentFactoryClass, Service service) throws MuleException {
        for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(new AnnotationMetaData(componentFactoryClass, null, ElementType.TYPE, annotation), ChannelType.Reply);
            if (inboundEndpoint == null) continue;
            service.getAsyncReplyMessageSource().addSource((MessageSource)inboundEndpoint);
        }
        this.processReplyRouters(componentFactoryClass, service);
    }

    protected String getValue(String key) {
        return this.parser.parse((Map)this.regProps, key);
    }
}

