/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.plugin.AbstractJettyMojo;
import org.mortbay.jetty.plugin.ScanTargetPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyRunMojo
extends AbstractJettyMojo {
    private boolean useTestClasspath;
    private String webXml;
    private File classesDirectory;
    private File testClassesDirectory;
    private File webAppSourceDirectory;
    private List pluginArtifacts;
    private File[] scanTargets;
    private ScanTargetPattern[] scanTargetPatterns;
    private List<File> classPathFiles;
    private List<File> extraScanTargets;

    @Override
    public void checkPomConfiguration() throws MojoExecutionException {
        int i;
        try {
            if (this.getWebAppSourceDirectory() == null || !this.getWebAppSourceDirectory().exists()) {
                this.webAppSourceDirectory = new File(this.project.getBasedir(), "src" + File.separator + "main" + File.separator + "webapp");
                this.getLog().info((CharSequence)("webAppSourceDirectory " + this.getWebAppSourceDirectory() + " does not exist. Defaulting to " + this.webAppSourceDirectory.getAbsolutePath()));
            } else {
                this.getLog().info((CharSequence)("Webapp source directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new MojoExecutionException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        this.getLog().info((CharSequence)("Reload Mechanic: " + this.reload));
        try {
            if (this.getClassesDirectory() != null) {
                if (!this.getClassesDirectory().exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.getClassesDirectory().getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.getClassesDirectory().getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        this.setExtraScanTargets(new ArrayList<File>());
        if (this.scanTargets != null) {
            for (i = 0; i < this.scanTargets.length; ++i) {
                this.getLog().info((CharSequence)("Added extra scan target:" + this.scanTargets[i]));
                this.getExtraScanTargets().add(this.scanTargets[i]);
            }
        }
        if (this.scanTargetPatterns != null) {
            for (i = 0; i < this.scanTargetPatterns.length; ++i) {
                Iterator itor = this.scanTargetPatterns[i].getIncludes().iterator();
                StringBuffer strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String includes = strbuff.toString();
                itor = this.scanTargetPatterns[i].getExcludes().iterator();
                strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String excludes = strbuff.toString();
                try {
                    List files = FileUtils.getFiles((File)this.scanTargetPatterns[i].getDirectory(), (String)includes, (String)excludes);
                    itor = files.iterator();
                    while (itor.hasNext()) {
                        this.getLog().info((CharSequence)("Adding extra scan target from pattern: " + itor.next()));
                    }
                    List<File> currentTargets = this.getExtraScanTargets();
                    if (currentTargets != null && !currentTargets.isEmpty()) {
                        currentTargets.addAll(files);
                        continue;
                    }
                    this.setExtraScanTargets(files);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        Resource webAppSourceDirectoryResource = Resource.newResource((String)this.webAppSourceDirectory.getCanonicalPath());
        if (this.webAppConfig.getWar() == null) {
            this.webAppConfig.setWar(webAppSourceDirectoryResource.toString());
        }
        if (this.webAppConfig.getBaseResource() == null) {
            this.webAppConfig.setBaseResource(webAppSourceDirectoryResource);
        }
        this.webAppConfig.setWebInfClasses(this.getClassesDirs());
        this.webAppConfig.setWebInfLib(this.getDependencyFiles());
        this.setClassPathFiles(this.setUpClassPath(this.webAppConfig.getWebInfClasses(), this.webAppConfig.getWebInfLib()));
        if (this.webAppConfig.getDescriptor() == null) {
            File f;
            Resource r;
            if (this.webXml != null && (r = Resource.newResource((String)this.webXml)).exists() && !r.isDirectory()) {
                this.webAppConfig.setDescriptor(r.toString());
            }
            if (this.webAppConfig.getDescriptor() == null && this.webAppConfig.getBaseResource() != null && (r = this.webAppConfig.getBaseResource().addPath("WEB-INF/web.xml")).exists() && !r.isDirectory()) {
                this.webAppConfig.setDescriptor(r.toString());
            }
            if (this.webAppConfig.getDescriptor() == null && this.webAppSourceDirectory != null && (f = new File(new File(this.webAppSourceDirectory, "WEB-INF"), "web.xml")).exists() && f.isFile()) {
                this.webAppConfig.setDescriptor(f.getCanonicalPath());
            }
        }
        this.getLog().info((CharSequence)("web.xml file = " + this.webAppConfig.getDescriptor()));
        if (this.webAppConfig.getClassPathFiles() == null) {
            this.webAppConfig.setClassPathFiles(this.getClassPathFiles());
        }
        this.getLog().info((CharSequence)("Webapp directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        File jettyWebXmlFile;
        Resource r;
        ArrayList<File> scanList = new ArrayList<File>();
        if (this.webAppConfig.getDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.webAppConfig.getDescriptor());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for web.xml", (Exception)e);
            }
        }
        if (this.webAppConfig.getJettyEnvXml() != null) {
            try {
                r = Resource.newResource((String)this.webAppConfig.getJettyEnvXml());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for jetty-env.xml", (Exception)e);
            }
        }
        if (this.webAppConfig.getDefaultsDescriptor() != null) {
            try {
                if (!"org/eclipse/jetty/webapp/webdefault.xml".equals(this.webAppConfig.getDefaultsDescriptor())) {
                    r = Resource.newResource((String)this.webAppConfig.getDefaultsDescriptor());
                    scanList.add(r.getFile());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for webdefaults.xml", (Exception)e);
            }
        }
        if (this.webAppConfig.getOverrideDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.webAppConfig.getOverrideDescriptor());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for webdefaults.xml", (Exception)e);
            }
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.getWebAppSourceDirectory(), "WEB-INF"))) != null) {
            scanList.add(jettyWebXmlFile);
        }
        scanList.addAll(this.getExtraScanTargets());
        scanList.add(this.getProject().getFile());
        scanList.addAll(this.getClassPathFiles());
        this.setScanList(scanList);
        ArrayList<Scanner.BulkListener> listeners = new ArrayList<Scanner.BulkListener>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunMojo.this.getProject().getFile().getCanonicalPath());
                    JettyRunMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + (Object)((Object)this.webAppConfig)));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webAppConfig.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanList.clear();
            this.scanList.add(new File(this.webAppConfig.getDescriptor()));
            if (this.webAppConfig.getJettyEnvXml() != null) {
                this.scanList.add(new File(this.webAppConfig.getJettyEnvXml()));
            }
            this.scanList.addAll(this.getExtraScanTargets());
            this.scanList.add(this.getProject().getFile());
            this.scanList.addAll(this.getClassPathFiles());
            this.getScanner().setScanDirs((List)this.scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webAppConfig.start();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private List<File> getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        ArrayList<Resource> overlays = new ArrayList<Resource>();
        for (Artifact artifact : this.getProject().getArtifacts()) {
            if (artifact.getType().equals("war")) {
                try {
                    Resource r = Resource.newResource((String)("jar:" + Resource.toURL((File)artifact.getFile()).toString() + "!/"));
                    overlays.add(r);
                    this.getExtraScanTargets().add(artifact.getFile());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) && (!this.useTestClasspath || !"test".equals(artifact.getScope()))) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " for WEB-INF/lib "));
        }
        this.webAppConfig.setOverlays(overlays);
        return dependencyFiles;
    }

    private List<File> setUpClassPath(List<File> webInfClasses, List<File> webInfJars) {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        classPathFiles.addAll(webInfClasses);
        classPathFiles.addAll(webInfJars);
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < classPathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)("classpath element: " + ((File)classPathFiles.get(i)).getName()));
            }
        }
        return classPathFiles;
    }

    private List<File> getClassesDirs() {
        ArrayList<File> classesDirs = new ArrayList<File>();
        if (this.useTestClasspath && this.testClassesDirectory != null) {
            classesDirs.add(this.testClassesDirectory);
        }
        if (this.getClassesDirectory() != null) {
            classesDirs.add(this.getClassesDirectory());
        }
        return classesDirs;
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        HandlerCollection contexts = (HandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; this.contextHandlers != null && i < this.contextHandlers.length; ++i) {
            contexts.addHandler((Handler)this.contextHandlers[i]);
        }
    }

    @Override
    public void applyJettyXml() throws Exception {
        if (this.getJettyXmlFiles() == null) {
            return;
        }
        for (File xmlFile : this.getJettyXmlFiles()) {
            this.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath()));
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)xmlFile));
            xmlConfiguration.configure((Object)this.server);
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public String getWebXml() {
        return this.webXml;
    }

    public void setWebXml(String webXml) {
        this.webXml = webXml;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebAppSourceDirectory() {
        return this.webAppSourceDirectory;
    }

    public void setWebAppSourceDirectory(File webAppSourceDirectory) {
        this.webAppSourceDirectory = webAppSourceDirectory;
    }

    public void setClassPathFiles(List<File> list) {
        this.classPathFiles = new ArrayList<File>(list);
    }

    public List<File> getClassPathFiles() {
        return this.classPathFiles;
    }

    public List<File> getExtraScanTargets() {
        return this.extraScanTargets;
    }

    public void setExtraScanTargets(List<File> list) {
        this.extraScanTargets = list;
    }

    public boolean isUseTestClasspath() {
        return this.useTestClasspath;
    }

    public void setUseTestClasspath(boolean useTestClasspath) {
        this.useTestClasspath = useTestClasspath;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public List getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public File[] getScanTargets() {
        return this.scanTargets;
    }

    public void setScanTargets(File[] scanTargets) {
        this.scanTargets = scanTargets;
    }

    public ScanTargetPattern[] getScanTargetPatterns() {
        return this.scanTargetPatterns;
    }

    public void setScanTargetPatterns(ScanTargetPattern[] scanTargetPatterns) {
        this.scanTargetPatterns = scanTargetPatterns;
    }
}

