/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.TransportSettings;
import com.mongodb.lang.Nullable;
import java.util.concurrent.ExecutorService;

public final class AsyncTransportSettings
extends TransportSettings {
    private final ExecutorService executorService;

    private AsyncTransportSettings(Builder builder) {
        this.executorService = builder.executorService;
    }

    static Builder builder() {
        return new Builder();
    }

    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return "AsyncTransportSettings{executorService=" + this.executorService + '}';
    }

    public static final class Builder {
        private ExecutorService executorService;

        private Builder() {
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = Assertions.notNull("executorService", executorService);
            return this;
        }

        public AsyncTransportSettings build() {
            return new AsyncTransportSettings(this);
        }
    }
}

