/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Immutable
public final class ProxySettings {
    private static final int DEFAULT_PORT = 1080;
    @Nullable
    private final String host;
    @Nullable
    private final Integer port;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProxySettings proxySettings) {
        return ProxySettings.builder().applySettings(proxySettings);
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port != null) {
            return this.port;
        }
        return 1080;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isProxyEnabled() {
        return this.host != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings that = (ProxySettings)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.username, this.password);
    }

    public String toString() {
        return "ProxySettings{host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + '}';
    }

    private ProxySettings(Builder builder) {
        if (builder.host == null) {
            Assertions.isTrue("proxyPort can only be specified with proxyHost", builder.port == null);
            Assertions.isTrue("proxyPassword can only be specified with proxyHost", builder.password == null);
            Assertions.isTrue("proxyUsername can only be specified with proxyHost", builder.username == null);
        }
        Assertions.isTrue("Both proxyUsername and proxyPassword must be set together. They cannot be set individually", builder.username == null == (builder.password == null));
        this.host = builder.host;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
    }

    public static final class Builder {
        private String host;
        private Integer port;
        private String username;
        private String password;

        private Builder() {
        }

        public Builder applySettings(ProxySettings proxySettings) {
            Assertions.notNull("ProxySettings", proxySettings);
            this.host = proxySettings.host;
            this.port = proxySettings.port;
            this.username = proxySettings.username;
            this.password = proxySettings.password;
            return this;
        }

        public Builder host(String host) {
            Assertions.notNull("proxyHost", host);
            Assertions.isTrueArgument("proxyHost is not empty", host.trim().length() > 0);
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            Assertions.isTrueArgument("proxyPort is within the valid range (0 to 65535)", port >= 0 && port <= 65535);
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            Assertions.notNull("username", username);
            Assertions.isTrueArgument("username is not empty", !username.isEmpty());
            Assertions.isTrueArgument("username's length in bytes is not greater than 255", username.getBytes(StandardCharsets.UTF_8).length <= 255);
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            Assertions.notNull("password", password);
            Assertions.isTrueArgument("password is not empty", !password.isEmpty());
            Assertions.isTrueArgument("password's length in bytes is not greater than 255", password.getBytes(StandardCharsets.UTF_8).length <= 255);
            this.password = password;
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            String proxyPassword;
            String proxyUsername;
            Integer proxyPort;
            String proxyHost = connectionString.getProxyHost();
            if (proxyHost != null) {
                this.host(proxyHost);
            }
            if ((proxyPort = connectionString.getProxyPort()) != null) {
                this.port(proxyPort);
            }
            if ((proxyUsername = connectionString.getProxyUsername()) != null) {
                this.username(proxyUsername);
            }
            if ((proxyPassword = connectionString.getProxyPassword()) != null) {
                this.password(proxyPassword);
            }
            return this;
        }

        public ProxySettings build() {
            return new ProxySettings(this);
        }
    }
}

