/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;

public class AsyncSingleConnectionReadBinding
extends AbstractReferenceCounted
implements AsyncReadBinding {
    private final ReadPreference readPreference;
    private final ServerDescription serverDescription;
    private final AsyncConnection connection;
    @Nullable
    private final ServerApi serverApi;

    public AsyncSingleConnectionReadBinding(ReadPreference readPreference, ServerDescription serverDescription, AsyncConnection connection, @Nullable ServerApi serverApi) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.serverDescription = Assertions.notNull("serverDescription", serverDescription);
        this.connection = Assertions.notNull("connection", connection).retain();
        this.serverApi = serverApi;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return NoOpSessionContext.INSTANCE;
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        callback.onResult(new AsyncSingleConnectionSource(), null);
    }

    @Override
    public AsyncReadBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public void release() {
        super.release();
        if (this.getCount() == 0) {
            this.connection.release();
        }
    }

    private class AsyncSingleConnectionSource
    extends AbstractReferenceCounted
    implements AsyncConnectionSource {
        AsyncSingleConnectionSource() {
            AsyncSingleConnectionReadBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return AsyncSingleConnectionReadBinding.this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return NoOpSessionContext.INSTANCE;
        }

        @Override
        @Nullable
        public ServerApi getServerApi() {
            return AsyncSingleConnectionReadBinding.this.serverApi;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            callback.onResult(AsyncSingleConnectionReadBinding.this.connection.retain(), null);
        }

        @Override
        public AsyncConnectionSource retain() {
            super.retain();
            return this;
        }

        @Override
        public void release() {
            super.release();
            if (super.getCount() == 0) {
                AsyncSingleConnectionReadBinding.this.release();
            }
        }
    }
}

