/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.operation.AbortTransactionOperation;
import com.mongodb.internal.operation.CommitTransactionOperation;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import java.util.concurrent.TimeUnit;

class AsyncClientSessionImpl
extends BaseClientSessionImpl
implements AsyncClientSession {
    private final OperationExecutor executor;
    private TransactionState transactionState = TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    AsyncClientSessionImpl(ServerSessionPool serverSessionPool, AsyncMongoClient mongoClient, ClientSessionOptions options, OperationExecutor executor) {
        super(serverSessionPool, mongoClient, options);
        this.executor = executor;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return firstMessageInCurrentTransaction;
        }
        if (this.transactionState == TransactionState.COMMITTED || this.transactionState == TransactionState.ABORTED) {
            this.cleanupTransaction(TransactionState.NONE);
        }
        return false;
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull("transactionOptions", transactionOptions);
        if (this.transactionState == TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            this.cleanupTransaction(TransactionState.IN);
        } else {
            this.transactionState = TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated.  Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.setPinnedServerAddress(null);
    }

    @Override
    public void commitTransaction(final SingleResultCallback<Void> callback) {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(TransactionState.COMMITTED);
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            boolean alreadyCommitted = this.commitInProgress || this.transactionState == TransactionState.COMMITTED;
            this.commitInProgress = true;
            this.executor.execute(new CommitTransactionOperation(this.transactionOptions.getWriteConcern(), alreadyCommitted).recoveryToken(this.getRecoveryToken()).maxCommitTime(this.transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), readConcern, this, new SingleResultCallback<Void>(){

                @Override
                public void onResult(Void result, Throwable t) {
                    if (t != null && t instanceof MongoException) {
                        AsyncClientSessionImpl.this.unpinServerAddressOnError((MongoException)t);
                    }
                    AsyncClientSessionImpl.this.commitInProgress = false;
                    AsyncClientSessionImpl.this.transactionState = TransactionState.COMMITTED;
                    callback.onResult(result, t);
                }
            });
        }
    }

    @Override
    public void abortTransaction(final SingleResultCallback<Void> callback) {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(TransactionState.ABORTED);
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            this.executor.execute(new AbortTransactionOperation(this.transactionOptions.getWriteConcern()).recoveryToken(this.getRecoveryToken()), readConcern, this, new SingleResultCallback<Void>(){

                @Override
                public void onResult(Void result, Throwable t) {
                    if (t != null && t instanceof MongoException) {
                        AsyncClientSessionImpl.this.unpinServerAddressOnError((MongoException)t);
                    }
                    AsyncClientSessionImpl.this.cleanupTransaction(TransactionState.ABORTED);
                    callback.onResult(null, null);
                }
            });
        }
    }

    private void unpinServerAddressOnError(MongoException e) {
        if (e.hasErrorLabel("TransientTransactionError") || e.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.setPinnedServerAddress(null);
        }
    }

    @Override
    public void close() {
        if (this.transactionState == TransactionState.IN) {
            this.abortTransaction(new SingleResultCallback<Void>(){

                @Override
                public void onResult(Void result, Throwable t) {
                    AsyncClientSessionImpl.super.close();
                }
            });
        } else {
            super.close();
        }
    }

    private void cleanupTransaction(TransactionState nextState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
    }

    private static enum TransactionState {
        NONE,
        IN,
        COMMITTED,
        ABORTED;

    }
}

