/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.template.utility.ClassUtil;
import org.mapstruct.ap.shaded.freemarker.template.utility.UndeclaredThrowableException;

public class _ConcurrentMapFactory {
    private static final Class concurrentMapClass;
    private static final Class bestHashMapClass;
    private static final Constructor bestHashMapClassConstructor;
    private static final int bestHashMapClassConstructorParamCnt;

    public static Map newMaybeConcurrentHashMap() {
        try {
            return (Map)bestHashMapClass.newInstance();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static Map newMaybeConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        try {
            if (bestHashMapClassConstructorParamCnt == 3) {
                return (Map)bestHashMapClassConstructor.newInstance(new Integer(initialCapacity), new Float(loadFactor), new Integer(concurrencyLevel));
            }
            if (bestHashMapClassConstructorParamCnt == 2) {
                return (Map)bestHashMapClassConstructor.newInstance(new Integer(initialCapacity), new Float(loadFactor));
            }
            throw new BugException();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static Map newThreadSafeMap() {
        Map map = _ConcurrentMapFactory.newMaybeConcurrentHashMap();
        return _ConcurrentMapFactory.isConcurrent(map) ? map : Collections.synchronizedMap(map);
    }

    public static boolean concurrentMapsAvailable() {
        return concurrentMapClass != null;
    }

    public static boolean isConcurrent(Map map) {
        return concurrentMapClass != null && concurrentMapClass.isInstance(map);
    }

    static {
        int constrParamCnt;
        Constructor constr;
        Class c;
        try {
            c = ClassUtil.forName("java.util.concurrent.ConcurrentMap");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        concurrentMapClass = c;
        try {
            c = ClassUtil.forName("java.util.concurrent.ConcurrentHashMap");
            try {
                constr = c.getConstructor(Integer.TYPE, Float.TYPE, Integer.TYPE);
                constrParamCnt = 3;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get ConcurrentHashMap constructor", e);
            }
        }
        catch (ClassNotFoundException e) {
            c = HashMap.class;
            try {
                constr = c.getConstructor(Integer.TYPE, Float.TYPE);
                constrParamCnt = 2;
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to get HashMap constructor", e2);
            }
        }
        bestHashMapClass = c;
        bestHashMapClassConstructor = constr;
        bestHashMapClassConstructorParamCnt = constrParamCnt;
    }
}

