/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.ext.spring.ApplicationContextHolder;
import ch.qos.logback.ext.spring.EventCacheMode;
import ch.qos.logback.ext.spring.ILoggingEventCache;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class DelegatingLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final Object lock;
    private String beanName;
    private ILoggingEventCache cache;
    private EventCacheMode cacheMode = EventCacheMode.ON;
    private volatile Appender<ILoggingEvent> delegate;

    public DelegatingLogbackAppender() {
        this.lock = new Object();
    }

    public void setCacheMode(String string) {
        this.cacheMode = Enum.valueOf(EventCacheMode.class, string.toUpperCase());
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.beanName == null || this.beanName.trim().isEmpty()) {
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new IllegalStateException("A 'name' or 'beanName' is required for DelegatingLogbackAppender");
            }
            this.beanName = this.name;
        }
        this.cache = this.cacheMode.createCache();
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.cache != null) {
            this.cache = null;
        }
        if (this.delegate != null) {
            this.delegate.stop();
            this.delegate = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.delegate == null) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isStarted()) {
                    return;
                }
                if (this.delegate == null) {
                    if (ApplicationContextHolder.hasApplicationContext()) {
                        Appender<ILoggingEvent> appender = this.getDelegate();
                        if (appender == null) {
                            return;
                        }
                        List<ILoggingEvent> list = this.cache.get();
                        for (ILoggingEvent iLoggingEvent2 : list) {
                            appender.doAppend((Object)iLoggingEvent2);
                        }
                        this.cache = null;
                        this.delegate = appender;
                    } else {
                        this.cache.put(iLoggingEvent);
                        return;
                    }
                }
            }
        }
        this.delegate.doAppend((Object)iLoggingEvent);
    }

    private Appender<ILoggingEvent> getDelegate() {
        ApplicationContext applicationContext = ApplicationContextHolder.getApplicationContext();
        try {
            Appender appender = (Appender)applicationContext.getBean(this.beanName, Appender.class);
            appender.setContext(this.getContext());
            if (!appender.isStarted()) {
                appender.start();
            }
            return appender;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            this.stop();
            this.addError("The ApplicationContext does not contain an Appender named [" + this.beanName + "]. This delegating appender will now stop processing events.", noSuchBeanDefinitionException);
            return null;
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }
}

