/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.plugin.execute;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.codehaus.groovy.maven.common.ArtifactItem;
import org.codehaus.groovy.maven.feature.Component;
import org.codehaus.groovy.maven.feature.Configuration;
import org.codehaus.groovy.maven.plugin.ComponentMojoSupport;
import org.codehaus.groovy.maven.plugin.execute.GroovyMavenProjectAdapter;
import org.codehaus.groovy.maven.plugin.execute.MavenUtility;
import org.codehaus.groovy.maven.plugin.execute.Source;
import org.codehaus.groovy.maven.runtime.ScriptExecutor;
import org.codehaus.groovy.maven.runtime.loader.realm.RealmManager;
import org.codehaus.groovy.maven.runtime.support.util.ResourceLoaderImpl;
import org.codehaus.groovy.maven.runtime.util.Callable;
import org.codehaus.groovy.maven.runtime.util.ClassSource;
import org.codehaus.groovy.maven.runtime.util.MagicAttribute;
import org.codehaus.groovy.maven.runtime.util.ResourceLoader;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteMojo
extends ComponentMojoSupport {
    private Source source;
    private ArtifactItem[] classpath;
    private File[] scriptpath;
    private Map defaults;
    private Map properties;
    private boolean trapAssertionErrors;
    private boolean sanitizeErrors;
    private MavenSession session;
    private Settings settings;
    private RealmManager realmManager;
    private MavenProjectHelper projectHelper;
    private ArtifactHandlerManager artifactHandlerManager;
    private MavenProjectBuilder mavenProjectBuilder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExecuteMojo() {
        super(ScriptExecutor.KEY);
    }

    protected List getProjectClasspathElements() throws DependencyResolutionRequiredException {
        return this.project.getRuntimeClasspathElements();
    }

    protected ArtifactItem[] getUserClassspathElements() {
        return this.classpath;
    }

    protected void process(Component component) throws Exception {
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        ScriptExecutor executor = (ScriptExecutor)component;
        if (this.source.configuration.getChildCount() != 0) {
            throw new MojoExecutionException("Invalid value for 'source' parameter; contains nested elements");
        }
        ClassSource classSource = ClassSource.forValue((String)this.source.configuration.getValue());
        ClassRealm realm = this.realmManager.createComponentRealm(this.provider(), this.createClassPath());
        MojoResourceLoader resourceLoader = new MojoResourceLoader((URLClassLoader)realm, classSource);
        Configuration context = this.createContext();
        this.log.debug("Executing {} w/context: {}", (Object)this.source, (Object)context);
        Object result = executor.execute(classSource, (ClassLoader)realm, (ResourceLoader)resourceLoader, context);
        this.log.debug("Result: {}", result);
        this.realmManager.releaseComponentRealm(realm);
    }

    private Configuration createContext() {
        Configuration context = new Configuration();
        Logger logger = LoggerFactory.getLogger((String)(this.project.getGroupId() + "." + this.project.getArtifactId() + ".ExecuteMojo"));
        context.set("log", (Object)logger);
        GroovyMavenProjectAdapter projectAdapter = new GroovyMavenProjectAdapter(this.project, this.session, this.properties, this.defaults);
        context.set("project", (Object)projectAdapter);
        context.set("pom", (Object)projectAdapter);
        context.set("session", (Object)this.session);
        context.set("settings", (Object)this.settings);
        context.set("maven", (Object)new MavenUtility(this.artifactResolver, this.artifactFactory, this.artifactMetadataSource, this.artifactHandlerManager, this.artifactRepository, this.remoteRepositories, this.projectHelper, this.mavenProjectBuilder, this.project, this.session));
        context.set("ant", (Object)MagicAttribute.ANT_BUILDER);
        context.set("fail", (Object)new FailClosure());
        return context;
    }

    static {
        $assertionsDisabled = !ExecuteMojo.class.desiredAssertionStatus();
    }

    private class FailClosure
    implements Callable {
        private FailClosure() {
        }

        public Object call(Object[] args) throws Exception {
            if (args == null || args.length == 0) {
                throw new MojoExecutionException("Failed");
            }
            if (args.length == 1) {
                if (args[0] instanceof Throwable) {
                    Throwable cause = (Throwable)args[0];
                    throw new MojoExecutionException(cause.getMessage(), cause);
                }
                throw new MojoExecutionException(String.valueOf(args[0]));
            }
            if (args.length == 2) {
                if (args[1] instanceof Throwable) {
                    throw new MojoExecutionException(String.valueOf(args[0]), (Throwable)args[1]);
                }
                throw new Error("Invalid arguments to fail(Object, Throwable), second argument must be a Throwable");
            }
            throw new Error("Too many arguments for fail(), expected one of: fail(), fail(Object) or fail(Object, Throwable)");
        }
    }

    private class MojoResourceLoader
    extends ResourceLoaderImpl {
        private final ClassSource classSource;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MojoResourceLoader(URLClassLoader classLoader, ClassSource classSource) {
            super((ClassLoader)classLoader);
            if (!$assertionsDisabled && classSource == null) {
                throw new AssertionError();
            }
            this.classSource = classSource;
        }

        protected URL resolve(String className, ClassLoader classLoader) throws MalformedURLException {
            URL url;
            File file;
            if (!$assertionsDisabled && className == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && classLoader == null) {
                throw new AssertionError();
            }
            String resource = this.toResourceName(className);
            if (ExecuteMojo.this.scriptpath != null) {
                for (int i = 0; i < ExecuteMojo.this.scriptpath.length; ++i) {
                    if (!$assertionsDisabled && ExecuteMojo.this.scriptpath[i] == null) {
                        throw new AssertionError();
                    }
                    file = new File(ExecuteMojo.this.scriptpath[i], resource);
                    if (!file.exists()) continue;
                    return file.toURI().toURL();
                }
            }
            if ((url = classLoader.getResource(resource)) == null && resource.startsWith("/")) {
                String tmp = resource.substring(1, resource.length());
                url = classLoader.getResource(tmp);
            }
            if (url == null) {
                File script = this.classSource.file;
                if (script != null && (file = new File(script.getParentFile(), resource)).exists()) {
                    return file.toURI().toURL();
                }
            } else {
                return url;
            }
            return super.resolve(className, classLoader);
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$maven$plugin$execute$ExecuteMojo == null ? (class$org$codehaus$groovy$maven$plugin$execute$ExecuteMojo = ExecuteMojo.class$("org.codehaus.groovy.maven.plugin.execute.ExecuteMojo")) : class$org$codehaus$groovy$maven$plugin$execute$ExecuteMojo).desiredAssertionStatus();
        }
    }
}

