/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class FullScopeDisabledExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private Configuration configuration;

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "full-scope-disabled";
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            rep.setFullScopeAllowed(Boolean.valueOf(false));
        }
    }

    private void validate(ClientRepresentation proposedClient) throws ClientPolicyException {
        if (proposedClient.isFullScopeAllowed() != null && proposedClient.isFullScopeAllowed().booleanValue()) {
            throw new ClientPolicyException("invalid_registration", "Not permitted to enable fullScopeAllowed");
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }
    }
}

