/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.value.convert;

import org.jtwig.exceptions.CalculationException;
import org.jtwig.model.position.Position;
import org.jtwig.util.ErrorMessageFormatter;

public interface Converter<T> {
    public Result<T> convert(Object var1);

    public static class Result<T> {
        private final T value;
        private final boolean defined;

        public static <T> Result<T> undefined() {
            return new Result<Object>(null, false);
        }

        public static <T> Result<T> defined(T value) {
            return new Result<T>(value, true);
        }

        public Result(T value, boolean defined) {
            this.value = value;
            this.defined = defined;
        }

        public T get() {
            return this.value;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public T or(T otherwise) {
            if (this.defined) {
                return this.value;
            }
            return otherwise;
        }

        public T orThrow(Position position, String message) {
            if (this.defined) {
                return this.value;
            }
            throw new CalculationException(ErrorMessageFormatter.errorMessage(position, message));
        }
    }
}

