/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.util.FunctionValueUtils;

public class BatchFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "batch";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.minimumNumberOfArguments(2).maximumNumberOfArguments(3);
        int groupSize = FunctionValueUtils.getNumber(request, 1).intValue();
        if (request.getNumberOfArguments() == 3) {
            return this.batch(request, 0, groupSize, request.get(2));
        }
        return this.batch(request, 0, groupSize);
    }

    private List<List<Object>> batch(FunctionRequest request, int index, int groupSize) {
        Iterator<Object> iterator = FunctionValueUtils.getCollection(request, index).iterator();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (!iterator.hasNext()) continue;
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    public List<List<Object>> batch(FunctionRequest request, int index, int groupSize, Object padding) {
        Iterator<Object> iterator = FunctionValueUtils.getCollection(request, index).iterator();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (iterator.hasNext()) {
                    batch.add(iterator.next());
                    continue;
                }
                batch.add(padding);
            }
            result.add(batch);
        }
        return result;
    }
}

