/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.nio.channels.Channel;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.MakeOpenFile();
    }

    public FileDescriptorIO(Ruby runtime2, IRubyObject fd) {
        super(runtime2, runtime2.getModule("FFI").getClass(CLASS_NAME));
        this.MakeOpenFile();
        ModeFlags modes = FileDescriptorIO.newModeFlags(runtime2, ModeFlags.RDWR);
        int fileno2 = RubyNumeric.fix2int(fd);
        FileStat stat2 = runtime2.getPosix().fstat(fileno2);
        Object channel = stat2.isSocket() ? new NativeSocketChannel(fileno2) : (stat2.isBlockDev() || stat2.isCharDev() ? new NativeDeviceChannel(fileno2) : new FileDescriptorByteChannel(runtime2, fileno2));
        this.openFile.setChannel((Channel)channel);
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = runtime2.defineClassUnder(CLASS_NAME, runtime2.getClass("IO"), FileDescriptorIO::new, module);
        result2.defineAnnotatedMethods(FileDescriptorIO.class);
        result2.defineAnnotatedConstants(FileDescriptorIO.class);
        return result2;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }
}

