/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ic.FileUtilKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010\u001e\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "write", "Ljava/io/File;", "outputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager performanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    @NotNull
    private static final Map<String, ProduceKind> produceMap;

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        Object $this$doExecute_u24lambda_u2d5;
        void $this$filterTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        File file2;
        String string2;
        Object[] commonSourcesArray;
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v0;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block44: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment);
                projectEnv.registerExtensionsFromPlugins(configuration);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                Iterable iterable = scriptingEvaluators;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl3 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v0 = t;
                    break block44;
                }
                v0 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v0;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            boolean projectEnv = false;
            boolean scriptingEvaluators = false;
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull((Object)arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.REPOSITORIES, repositories);
        Object[] objectArray = commonSourcesArray = arguments2.getCommonSources();
        Set set = objectArray == null ? null : ArraysKt.toSet((Object[])objectArray);
        Set commonSources = set == null ? SetsKt.emptySet() : set;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            CharSequence it = arguments2.getIncludes();
            boolean bl3 = false;
            boolean bl = false;
            if (it == null || it.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string3 = arguments2.getIrModuleName();
        if (string3 == null) {
            String string4 = FileUtil.getNameWithoutExtension(outputFile);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameWithoutExtension(outputFile)");
            string2 = string4;
        } else {
            string2 = string3;
        }
        String moduleName = string2;
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JsConfig config = new JsConfig(projectJs, configurationJs, CompilerEnvironment.INSTANCE);
        File file3 = outputFile.getParentFile();
        if (file3 == null) {
            File file4 = outputFile.getAbsoluteFile().getParentFile();
            file2 = file4;
            Intrinsics.checkNotNull((Object)file4);
        } else {
            file2 = file3;
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        Object object3 = configuration.get(JSConfigurationKeys.REPOSITORIES);
        Object object4 = object3 == null ? (Collection)CollectionsKt.emptyList() : object3;
        MessageCollector messageCollector3 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector3 == null) {
            String string5 = "Could not find message collector";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        object3 = messageCollector3;
        KotlinLibraryResolveResult resolvedLibraries = JsLibraryResolverKt.jsResolveLibraries(libraries, (Collection<String>)object4, K2JsIrCompilerKt.messageCollectorLogger((MessageCollector)object3));
        Iterable $this$map$iv = friendLibraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string6 = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new File((String)it).getAbsolutePath();
            object2.add(object);
        }
        List friendAbsolutePaths = (List)destination$iv$iv;
        Iterable $this$filter$iv = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            boolean bl4 = false;
            if (!friendAbsolutePaths.contains(it.getLibraryFile().getAbsolutePath())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List friendDependencies = (List)destination$iv$iv2;
        List icCaches = K2JsIrCompiler.Companion.configureLibraries(arguments2.getCacheDirectories());
        if (arguments2.getIrBuildCache()) {
            Object v6;
            block45: {
                boolean bl;
                Collection<String> collection;
                K2JsIrCompiler $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object element$iv$iv;
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "", null, 4, null);
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, Intrinsics.stringPlus((String)"to: ", (Object)outputFilePath), null, 4, null);
                Object $i$f$filter2 = arguments2.getCacheDirectories();
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, (String)($i$f$filter2 == null ? "" : $i$f$filter2), null, 4, null);
                $i$f$filter2 = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
                object = CompilerMessageSeverity.INFO;
                object2 = messageCollector2;
                boolean $i$f$map2 = false;
                destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv222 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                element$iv$iv = $this$mapTo$iv$iv2.iterator();
                while (element$iv$iv.hasNext()) {
                    void it;
                    Object item$iv$iv = element$iv$iv.next();
                    KotlinLibrary bl4 = (KotlinLibrary)item$iv$iv;
                    collection = destination$iv$iv222;
                    bl = false;
                    String string7 = it.getLibraryName();
                    collection.add(string7);
                }
                collection = (List)destination$iv$iv222;
                MessageCollector.DefaultImpls.report$default((MessageCollector)object2, (CompilerMessageSeverity)((Object)object), collection.toString(), null, 4, null);
                String string8 = arguments2.getIncludes();
                Intrinsics.checkNotNull((Object)string8);
                String includes = string8;
                $this$mapTo$iv$iv2 = this;
                boolean destination$iv$iv222 = false;
                $i$f$mapTo2 = false;
                $this$doExecute_u24lambda_u2d5 = $this$mapTo$iv$iv2;
                boolean bl5 = false;
                Collection it = sourcesFiles;
                bl = false;
                if (!it.isEmpty()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                }
                List allLibraries2 = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
                Iterable iterable3 = allLibraries2;
                boolean bl6 = false;
                Iterable iterable4 = iterable3;
                boolean bl7 = false;
                for (Object t : iterable4) {
                    KotlinLibrary it2 = (KotlinLibrary)t;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)it2.getLibraryFile().getAbsolutePath(), (Object)new File(includes).getAbsolutePath())) continue;
                    v6 = t;
                    break block45;
                }
                v6 = null;
            }
            Intrinsics.checkNotNull(v6);
            KotlinLibrary mainLib2 = v6;
            MainModule.Klib mainModule = new MainModule.Klib(mainLib2);
            long start2 = System.currentTimeMillis();
            CompilerConfiguration $i$f$mapTo2 = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo2, (String)"config.configuration");
            AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport($i$f$mapTo2);
            $i$f$mapTo2 = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo2, (String)"config.configuration");
            if (FileUtilKt.buildCache$default(outputFilePath, projectJs, mainModule, abstractAnalyzerWithCompilerReport, $i$f$mapTo2, resolvedLibraries, friendDependencies, null, false, FileUtilKt.checkCaches(resolvedLibraries, icCaches, mainModule.getLib().getLibraryFile().getAbsolutePath()), 384, null)) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC cache building duration: " + (System.currentTimeMillis() - start2) + "ms", null, 4, null);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC cache up-to-date check duration: " + (System.currentTimeMillis() - start2) + "ms", null, 4, null);
            }
            return ExitCode.OK;
        }
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            if (arguments2.getIrProduceKlibFile()) {
                boolean includes = Intrinsics.areEqual((Object)FilesKt.getExtension((File)outputFile), (Object)"klib");
                boolean mainModule = false;
                boolean start2 = false;
                if (!includes) {
                    boolean bl9 = false;
                    String start2 = "Please set up .klib file as output";
                    throw (Throwable)new IllegalArgumentException(start2.toString());
                }
            }
            Object includes = config.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)includes, (String)"config.project");
            Project project = includes;
            includes = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)includes, (String)"config.configuration");
            AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport((CompilerConfiguration)includes);
            includes = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)includes, (String)"config.configuration");
            Object object5 = includes;
            IrFactory irFactory = new PersistentIrFactory();
            includes = outputFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)includes, (String)"outputFile.path");
            KlibKt.generateKLib(project, sourcesFiles, abstractAnalyzerWithCompilerReport, (CompilerConfiguration)object5, resolvedLibraries, friendDependencies, irFactory, (String)includes, arguments2.getIrProduceKlibDir(), arguments2.getIrPerModuleOutputName());
        }
        if (arguments2.getIrProduceJs()) {
            CompilationOutputs compilationOutputs;
            MainModule mainModule;
            MainModule mainModule2;
            Object mainLib;
            boolean bl;
            Object it;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, Intrinsics.stringPlus((String)"Produce executable: ", (Object)outputFilePath), null, 4, null);
            String includes = arguments2.getCacheDirectories();
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, includes == null ? "" : includes, null, 4, null);
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
            String includes2 = arguments2.getIncludes();
            if (includes2 != null) {
                Object v12;
                block46: {
                    Collection bl9 = sourcesFiles;
                    boolean $i$f$mapTo2 = false;
                    if (!bl9.isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                    }
                    List allLibraries = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
                    $this$doExecute_u24lambda_u2d5 = allLibraries;
                    boolean bl5 = false;
                    Iterable allLibraries2 = $this$doExecute_u24lambda_u2d5;
                    boolean mainLib2 = false;
                    for (Object t : allLibraries2) {
                        it = (KotlinLibrary)t;
                        bl = false;
                        if (!Intrinsics.areEqual((Object)it.getLibraryFile().getAbsolutePath(), (Object)new File(includes2).getAbsolutePath())) continue;
                        v12 = t;
                        break block46;
                    }
                    v12 = null;
                }
                Intrinsics.checkNotNull(v12);
                mainLib = v12;
                mainModule2 = new MainModule.Klib((KotlinLibrary)mainLib);
            } else {
                mainModule2 = mainModule = (MainModule)new MainModule.SourceFiles(sourcesFiles);
            }
            if (arguments2.getWasm()) {
                mainLib = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)mainLib, (String)"config.configuration");
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport((CompilerConfiguration)mainLib);
                mainLib = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)mainLib, (String)"config.configuration");
                WasmCompilerResult res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm(projectJs, mainModule, abstractAnalyzerWithCompilerReport, (CompilerConfiguration)mainLib, new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), IrFactoryImpl.INSTANCE, resolvedLibraries, friendDependencies, SetsKt.setOf((Object)new FqName("main")));
                File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wasm");
                Intrinsics.checkNotNull((Object)file5);
                File outputWasmFile = file5;
                FilesKt.writeBytes((File)outputWasmFile, (byte[])res2.getWasm());
                File file6 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wat");
                Intrinsics.checkNotNull((Object)file6);
                File outputWatFile = file6;
                FilesKt.writeText$default((File)outputWatFile, (String)res2.getWat(), null, (int)2, null);
                String runner = kotlin.text.StringsKt.trimIndent((String)("\n                    const wasmBinary = read(String.raw`" + outputWasmFile.getAbsoluteFile() + "`, 'binary');\n                    const wasmModule = new WebAssembly.Module(wasmBinary);\n                    const wasmInstance = new WebAssembly.Instance(wasmModule, { runtime, js_code });\n                    wasmInstance.exports.main();\n                "));
                FilesKt.writeText$default((File)outputFile, (String)(res2.getJs() + '\n' + runner), null, (int)2, null);
                return ExitCode.OK;
            }
            long start = System.currentTimeMillis();
            CompilerConfiguration allLibraries2 = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)allLibraries2, (String)"config.configuration");
            AnalyzerWithCompilerReport runner = new AnalyzerWithCompilerReport(allLibraries2);
            allLibraries2 = config.getConfiguration();
            IrFactory mainLib2 = arguments2.getIrDceDriven() ? (IrFactory)new PersistentIrFactory() : (IrFactory)IrFactoryImpl.INSTANCE;
            boolean bl10 = !arguments2.getIrDce();
            boolean bl11 = arguments2.getIrDce();
            it = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector2);
            bl = arguments2.getIrDceDriven();
            boolean bl12 = arguments2.getIrPerModule();
            boolean bl13 = arguments2.getIrPropertyLazyInitialization();
            boolean bl14 = arguments2.getIrLegacyPropertyAccess();
            boolean bl15 = arguments2.getIrBaseClassInMetadata();
            boolean bl16 = arguments2.getIrSafeExternalBoolean();
            RuntimeDiagnostic runtimeDiagnostic = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrSafeExternalBooleanDiagnostic(), messageCollector2);
            Collection collection = icCaches;
            boolean bl17 = false;
            boolean bl18 = !collection.isEmpty();
            Object object6 = icCaches;
            boolean bl19 = false;
            boolean bl20 = !object6.isEmpty();
            Collection collection2 = icCaches;
            boolean bl21 = false;
            object6 = !collection2.isEmpty() ? FileUtilKt.checkCaches(resolvedLibraries, icCaches, ((MainModule.Klib)mainModule).getLib().getLibraryFile().getAbsolutePath()).getData() : MapsKt.emptyMap();
            AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = runner;
            Intrinsics.checkNotNullExpressionValue((Object)allLibraries2, (String)"configuration");
            CompilerResult compiledModule = CompilerKt.compile$default(projectJs, mainModule, abstractAnalyzerWithCompilerReport, allLibraries2, phaseConfig, mainLib2, resolvedLibraries, friendDependencies, mainCallArguments, null, bl10, bl11, bl, (RuntimeDiagnostic)((Object)it), false, bl12, true, bl13, bl14, bl15, bl18, bl16, runtimeDiagnostic, bl20, (Map)object6, 16896, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            if (arguments2.getIrDce() && !arguments2.getIrDceDriven()) {
                CompilationOutputs compilationOutputs2 = compiledModule.getOutputsAfterDce();
                compilationOutputs = compilationOutputs2;
                Intrinsics.checkNotNull((Object)compilationOutputs2);
            } else {
                CompilationOutputs compilationOutputs3 = compiledModule.getOutputs();
                compilationOutputs = compilationOutputs3;
                Intrinsics.checkNotNull((Object)compilationOutputs3);
            }
            CompilationOutputs outputs = compilationOutputs;
            this.write(outputFile, outputs);
            Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs.getDependencies();
            boolean $i$f$forEach = false;
            Object object7 = $this$forEach$iv.iterator();
            while (object7.hasNext()) {
                Pair<String, CompilationOutputs> element$iv;
                Pair<String, CompilationOutputs> $dstr$name$content = element$iv = object7.next();
                boolean bl22 = false;
                String name = (String)$dstr$name$content.component1();
                CompilationOutputs content = (CompilationOutputs)$dstr$name$content.component2();
                this.write(FilesKt.resolveSibling((File)outputFile, (String)Intrinsics.stringPlus((String)name, (Object)".js")), content);
            }
            if (arguments2.getGenerateDts()) {
                File file7 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "d.ts");
                Intrinsics.checkNotNull((Object)file7);
                File dtsFile = file7;
                String string9 = compiledModule.getTsDefinitions();
                if (string9 == null) {
                    object7 = "No ts definitions";
                    boolean bl23 = false;
                    throw (Throwable)new IllegalStateException(object7.toString());
                }
                FilesKt.writeText$default((File)dtsFile, (String)string9, null, (int)2, null);
            }
        }
        return ExitCode.OK;
    }

    private final void write(File $this$write, CompilationOutputs outputs) {
        FilesKt.writeText$default((File)$this$write, (String)outputs.getJsCode(), null, (int)2, null);
        String string2 = outputs.getSourceMap();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            File mapFile = FilesKt.resolveSibling((File)$this$write, (String)Intrinsics.stringPlus((String)$this$write.getName(), (Object)".map"));
            FilesKt.appendText$default((File)$this$write, (String)Intrinsics.stringPlus((String)"\n//# sourceMappingURL=", (Object)mapFile.getName()), null, (int)2, null);
            FilesKt.writeText$default((File)mapFile, (String)it, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        String moduleKindName;
        ModuleKind moduleKind;
        String $this$filterNotTo$iv$iv;
        boolean $i$f$filterNotTo;
        Object destination$iv$iv;
        Object $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222 = false;
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull((Object)string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222 = Intrinsics.stringPlus((String)"Unsupported ECMA version: ", (Object)string2);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222));
            }
        }
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                String string3 = arguments2.getSourceMapPrefix();
                Intrinsics.checkNotNull((Object)string3);
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, string3);
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222 = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                Intrinsics.checkNotNullExpressionValue($i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222, (String)"split(sourceMapSourceRoots, File.pathSeparator)");
                List<String> sourceMapSourceRootList = $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222;
                configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNot$iv;
            List list2;
            Object object;
            Iterable $this$dropLastWhile$iv;
            $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222 = friendModules;
            String string4 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
            int n = 0;
            string4 = new Regex(string4);
            n = 0;
            boolean bl = false;
            $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222 = string4.split((CharSequence)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$222, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl3 = false;
                    object = it;
                    boolean bl4 = false;
                    if (object.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterNotTo = false;
            object = $this$filterNotTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence charSequence = it;
                boolean bl6 = false;
                if (charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        $this$filterNotTo$iv$iv = arguments2.getErrorTolerancePolicy();
        if ($this$filterNotTo$iv$iv == null) {
            errorTolerancePolicy = null;
        } else {
            destination$iv$iv = $this$filterNotTo$iv$iv;
            $i$f$filterNotTo = false;
            boolean bl = false;
            Object it = destination$iv$iv;
            boolean bl7 = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy((String)it);
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        $this$filterNotTo$iv$iv = errorTolerancePolicy2;
        if ($this$filterNotTo$iv$iv == null ? false : ((ErrorTolerancePolicy)((Object)$this$filterNotTo$iv$iv)).getAllowErrors()) {
            configuration.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD))};
        moduleKindMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))};
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(null, (Object)((Object)ProduceKind.DEFAULT)), TuplesKt.to((Object)"js", (Object)((Object)ProduceKind.JS)), TuplesKt.to((Object)"klib", (Object)((Object)ProduceKind.KLIB))};
        produceMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                String string2 = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : Intrinsics.stringPlus((String)file2.getName(), (Object)" (no virtual file)");
                collection.add(string2);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, Intrinsics.stringPlus((String)"Compiling source files: ", (Object)StringsKt.join(fileNames, ", ")), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            String string2 = libraryString;
            return string2 == null ? CollectionsKt.emptyList() : this.splitByPathSeparator(string2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string2.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    int n2 = 0;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence3 = it;
                boolean bl4 = false;
                if (charSequence3.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

