/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (!IrUtilsKt.isEnumClass(irClass2)) {
            return;
        }
        new EnumClassTransformer(irClass2).run();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u000ej\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "declarationToEnumEntry", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumEntryOrdinals", "Lgnu/trove/TObjectIntHashMap;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "loweredEnumConstructorParameters", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/HashMap;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildEnumEntryField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntry", "buildValuesField", "valuesHelperFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildValuesHelperFunction", "run", "", "EnumClassCallTransformer", "EnumClassDeclarationsTransformer", "backend.jvm"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final TObjectIntHashMap<IrEnumEntry> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;

        public EnumClassTransformer(IrClass irClass2) {
            Intrinsics.checkNotNullParameter((Object)EnumClassLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            this.irClass = irClass2;
            boolean bl = false;
            this.loweredEnumConstructors = new HashMap();
            bl = false;
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new TObjectIntHashMap();
            bl = false;
            this.declarationToEnumEntry = new LinkedHashMap();
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public final void run() {
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Object $this$forEach$iv = SequencesKt.withIndex((Sequence)sequence2);
            boolean $i$f$forEach22 = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                boolean bl;
                IrDeclarationBase irDeclarationBase;
                Object element$iv = object.next();
                IndexedValue $dstr$index$enumEntry = (IndexedValue)element$iv;
                boolean bl2 = false;
                int index2 = $dstr$index$enumEntry.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)$dstr$index$enumEntry.component2();
                this.enumEntryOrdinals.put((Object)enumEntry, index2);
                Object object2 = enumEntry.getCorrespondingClass();
                if (object2 != null) {
                    irDeclarationBase = object2;
                    bl = false;
                    boolean bl3 = false;
                    IrClass entryClass = irDeclarationBase;
                    boolean bl4 = false;
                    Map<IrDeclaration, IrEnumEntry> map = this.declarationToEnumEntry;
                    boolean bl5 = false;
                    map.put(entryClass, enumEntry);
                }
                object2 = this.declarationToEnumEntry;
                irDeclarationBase = this.buildEnumEntryField(enumEntry);
                bl = false;
                object2.put(irDeclarationBase, enumEntry);
            }
            CollectionsKt.removeAll(this.irClass.getDeclarations(), (Function1)run.2.INSTANCE);
            $this$forEach$iv = this.irClass;
            Collection $i$f$forEach22 = $this$forEach$iv.getDeclarations();
            object = this.declarationToEnumEntry.keySet();
            boolean bl = false;
            CollectionsKt.addAll((Collection)$i$f$forEach22, (Iterable)object);
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassDeclarationsTransformer(valuesField));
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassCallTransformer());
        }

        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrField irField = EnumClassLowering.this.getContext().getCachedDeclarations$backend_jvm().getFieldForEnumEntry(enumEntry);
            boolean bl = false;
            boolean bl2 = false;
            IrField $this$buildEnumEntryField_u24lambda_u2d2 = irField;
            boolean bl3 = false;
            IrElementBase irElementBase = enumEntry.getInitializerExpression();
            Intrinsics.checkNotNull((Object)irElementBase);
            $this$buildEnumEntryField_u24lambda_u2d2.setInitializer(new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpressionBody)irElementBase).getExpression(), $this$buildEnumEntryField_u24lambda_u2d2)));
            irElementBase = $this$buildEnumEntryField_u24lambda_u2d2;
            irElementBase.setAnnotations(CollectionsKt.plus((Collection)irElementBase.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            void $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            void $this$addFunction$iv;
            Object object = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u2d3 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
            boolean bl4 = false;
            Object object2 = Name.identifier("$values");
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"identifier(VALUES_HELPER_FUNCTION_NAME)");
            $this$buildValuesHelperFunction_u24lambda_u2d3.setName((Name)object2);
            object2 = new IrType[]{IrUtilsKt.getDefaultType(this.getIrClass())};
            $this$buildValuesHelperFunction_u24lambda_u2d3.setReturnType(IrTypesKt.typeWith((IrClassifierSymbol)enumClassLowering.getContext().getIrBuiltIns().getArrayClass(), object2));
            object2 = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u2d3.setVisibility((DescriptorVisibility)object2);
            $this$buildValuesHelperFunction_u24lambda_u2d3.setOrigin(IrDeclarationOrigin.SYNTHETIC_HELPER_FOR_ENUM_VALUES.INSTANCE);
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent((IrDeclarationContainer)$this$addFunction$iv);
            object = $this$buildFun$iv$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            boolean bl7 = false;
            boolean bl8 = false;
            Object $this$buildValuesHelperFunction_u24lambda_u2d6 = object;
            boolean bl9 = false;
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(enumClassLowering.getContext(), ((IrSimpleFunction)$this$buildValuesHelperFunction_u24lambda_u2d6).getSymbol(), 0, 0, 6, null);
            bl6 = false;
            boolean bl10 = false;
            JvmIrBuilder $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = jvmIrBuilder;
            Object object3 = $this$buildValuesHelperFunction_u24lambda_u2d6;
            boolean bl11 = false;
            $this$buildValuesHelperFunction_u24lambda_u2d3 = $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            IrType arrayType$iv = ((IrFunction)$this$buildValuesHelperFunction_u24lambda_u2d6).getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl12 = false;
            boolean bl13 = false;
            IrArrayBuilder $this$irArray_u24lambda_u2d0$iv = irArrayBuilder;
            boolean bl14 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u2d0$iv;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5;
            boolean bl15 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4;
                $this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.unaryPlus(ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u2d6_u24lambda_u2d5, null, irField));
            }
            Unit unit = Unit.INSTANCE;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, irArrayBuilder.build());
            ((IrFunction)object3).setBody(irExpressionBody);
            return (IrFunction)object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8;
            void $this$addField$iv;
            IrDeclarationBase irDeclarationBase = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u2d4$iv$iv = irFieldBuilder;
            boolean $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv22 = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u2d7 = $this$buildField_u24lambda_u2d4$iv$iv;
            boolean bl3 = false;
            Object object = Name.identifier("$VALUES");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(ImplementationBodyCodegen.ENUM_VALUES_FIELD_NAME)");
            $this$buildValuesField_u24lambda_u2d7.setName((Name)object);
            object = new IrType[]{IrUtilsKt.getDefaultType(this.getIrClass())};
            $this$buildValuesField_u24lambda_u2d7.setType(IrTypesKt.typeWith((IrClassifierSymbol)enumClassLowering.getContext().getIrBuiltIns().getArrayClass(), object));
            object = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PRIVATE");
            $this$buildValuesField_u24lambda_u2d7.setVisibility((DescriptorVisibility)object);
            $this$buildValuesField_u24lambda_u2d7.setOrigin(IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE);
            $this$buildValuesField_u24lambda_u2d7.setFinal(true);
            $this$buildValuesField_u24lambda_u2d7.setStatic(true);
            IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv$iv, $this$buildField_u24lambda_u2d4$iv$iv);
            $i$f$buildField = false;
            boolean bl4 = false;
            IrField field$iv = irField;
            boolean bl5 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add(field$iv);
            irDeclarationBase = irField;
            enumClassLowering = EnumClassLowering.this;
            boolean bl6 = false;
            boolean bl7 = false;
            IrDeclarationBase $this$buildValuesField_u24lambda_u2d9 = irDeclarationBase;
            boolean bl8 = false;
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(enumClassLowering.getContext(), ((IrField)$this$buildValuesField_u24lambda_u2d9).getSymbol(), 0, 0, 6, null);
            bl2 = false;
            boolean bl9 = false;
            JvmIrBuilder $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv22 = jvmIrBuilder;
            IrDeclarationBase irDeclarationBase2 = $this$buildValuesField_u24lambda_u2d9;
            boolean bl10 = false;
            object = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2d9_u24lambda_u2d8, valuesHelperFunction.getSymbol()));
            ((IrField)irDeclarationBase2).setInitializer((IrExpressionBody)object);
            return irDeclarationBase;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getValuesField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;

            public EnumClassDeclarationsTransformer(IrField valuesField) {
                Intrinsics.checkNotNullParameter((Object)EnumClassTransformer.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)valuesField, (String)"valuesField");
                this.valuesField = valuesField;
            }

            @NotNull
            public final IrField getValuesField() {
                return this.valuesField;
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration2) ? super.visitClass(declaration2) : (IrStatement)declaration2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.getContext().getIrFactory();
                boolean $i$f$buildConstructor = false;
                Object object = new IrFunctionBuilder();
                boolean bl = false;
                boolean bl2 = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u2d18$iv = object;
                boolean bl3 = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u2d0 = $this$buildConstructor_u24lambda_u2d18$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u2d0.updateFrom(declaration2);
                $this$visitConstructor_u24lambda_u2d0.setReturnType(declaration2.getReturnType());
                IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2d18$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                object = EnumClassTransformer.this;
                bl = false;
                bl2 = false;
                IrConstructor $this$visitConstructor_u24lambda_u2d3 = irConstructor2;
                boolean bl4 = false;
                $this$visitConstructor_u24lambda_u2d3.setParent(declaration2.getParent());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u2d3, "$enum$name", enumClassLowering.getContext().getIrBuiltIns().getStringType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE);
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u2d3, "$enum$ordinal", enumClassLowering.getContext().getIrBuiltIns().getIntType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE);
                Object object2 = $this$visitConstructor_u24lambda_u2d3;
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration2.getValueParameters();
                Collection collection2 = ((IrFunction)object2).getValueParameters();
                IrConstructor irConstructor3 = object2;
                boolean $i$f$map = false;
                void var14_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, $this$visitConstructor_u24lambda_u2d3, null, param.getIndex() + 2, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    IrValueParameter newParam = irValueParameter2;
                    boolean bl8 = false;
                    Map map = ((EnumClassTransformer)object).loweredEnumConstructorParameters;
                    IrValueParameterSymbol irValueParameterSymbol = param.getSymbol();
                    boolean bl9 = false;
                    map.put(irValueParameterSymbol, newParam);
                    IrValueParameter irValueParameter3 = irValueParameter2;
                    collection.add(irValueParameter3);
                }
                collection = (List)destination$iv$iv;
                irConstructor3.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                object2 = declaration2.getBody();
                $this$visitConstructor_u24lambda_u2d3.setBody(object2 == null ? null : (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)object2, $this$visitConstructor_u24lambda_u2d3));
                object2 = ((EnumClassTransformer)object).loweredEnumConstructors;
                IrConstructorSymbol irConstructorSymbol = declaration2.getSymbol();
                boolean bl10 = false;
                object2.put(irConstructorSymbol, $this$visitConstructor_u24lambda_u2d3);
                $this$visitConstructor_u24lambda_u2d3.setMetadata(declaration2.getMetadata());
                return irConstructor2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrExpression irExpression;
                IrBuilderWithScope irBuilderWithScope;
                void $this$visitSimpleFunction_u24lambda_u2d7;
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Object object3 = declaration2.getBody();
                if (object3 == null) {
                    object2 = null;
                } else {
                    IrBody $this$safeAs$iv = object3;
                    boolean $i$f$safeAs = false;
                    IrBody irBody = $this$safeAs$iv;
                    if (!(irBody instanceof IrSyntheticBody)) {
                        irBody = null;
                    }
                    object2 = object = (IrSyntheticBody)irBody;
                }
                if (object == null) {
                    return declaration2;
                }
                IrSyntheticBody body2 = object;
                object = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(EnumClassLowering.this.getContext(), declaration2.getSymbol(), 0, 0, 6, null);
                object3 = EnumClassTransformer.this;
                boolean bl = false;
                boolean bl2 = false;
                Object object4 = object;
                IrSimpleFunction irSimpleFunction = declaration2;
                boolean bl3 = false;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d7;
                IrSyntheticBodyKind irSyntheticBodyKind = body2.getKind();
                int n = WhenMappings.$EnumSwitchMapping$0[irSyntheticBodyKind.ordinal()];
                switch (n) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d4;
                        void $this$irArray$iv;
                        void var11_13 = $this$visitSimpleFunction_u24lambda_u2d7;
                        IrType arrayType$iv = this.getValuesField().getType();
                        boolean $i$f$irArray = false;
                        IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        IrArrayBuilder $this$irArray_u24lambda_u2d0$iv = irArrayBuilder;
                        boolean bl6 = false;
                        IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u2d0$iv;
                        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope2;
                        boolean bl7 = false;
                        $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d4.addSpread(ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d7, null, this.getValuesField()));
                        Unit unit = Unit.INSTANCE;
                        irBuilderWithScope = irBuilderWithScope3;
                        irExpression = irArrayBuilder.build();
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5;
                        void $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d6;
                        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d7, $this$visitSimpleFunction_u24lambda_u2d7.getBackendContext().getIr().getSymbols().getEnumValueOfFunction());
                        boolean bl8 = false;
                        boolean bl9 = false;
                        IrCall irCall2 = irCall;
                        IrBuilderWithScope irBuilderWithScope4 = irBuilderWithScope2;
                        boolean bl10 = false;
                        FunctionReferenceLowering.Companion companion = FunctionReferenceLowering.Companion;
                        boolean bl11 = false;
                        boolean bl12 = false;
                        FunctionReferenceLowering.Companion $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d4 = companion;
                        int n2 = 0;
                        void var23_37 = $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d6;
                        boolean bl13 = false;
                        IrCall irCall3 = $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5.javaClassReference$backend_jvm((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d7, IrUtilsKt.getDefaultType(((EnumClassTransformer)object3).getIrClass()), $this$visitSimpleFunction_u24lambda_u2d7.getBackendContext());
                        var23_37.putValueArgument(n2, irCall3);
                        $this$visitSimpleFunction_u24lambda_u2d7_u24lambda_u2d6.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u2d7, declaration2.getValueParameters().get(0)));
                        Unit unit = Unit.INSTANCE;
                        irBuilderWithScope = irBuilderWithScope4;
                        irExpression = irCall;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, irExpression);
                irSimpleFunction.setBody(irExpressionBody);
                return declaration2;
            }

            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "passConstructorArguments", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            public EnumClassCallTransformer() {
                Intrinsics.checkNotNullParameter((Object)EnumClassTransformer.this, (String)"this$0");
            }

            @Override
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration2) ? super.visitClassNew(declaration2) : (IrStatement)declaration2;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Object object = EnumClassTransformer.this.loweredEnumConstructorParameters;
                Object object2 = expression2.getSymbol();
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)object.get(object2);
                if (irValueParameter == null) {
                    irExpression = expression2;
                } else {
                    object2 = irValueParameter;
                    bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrValueDeclaration)it).getType(), ((IrValueParameter)it).getSymbol(), expression2.getOrigin());
                    irExpression = (IrExpression)object;
                }
                return irExpression;
            }

            @Override
            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                Object object = EnumClassTransformer.this.loweredEnumConstructorParameters;
                Object object2 = expression2.getSymbol();
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)object.get(object2);
                if (irValueParameter == null) {
                    irExpression = expression2;
                } else {
                    object2 = irValueParameter;
                    bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrValueDeclaration)it).getType(), ((IrValueParameter)it).getSymbol(), expression2.getValue(), expression2.getOrigin());
                    irExpression = (IrExpression)object;
                }
                return irExpression;
            }

            @Override
            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                Object object = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)object);
                IrSymbol scopeOwnerSymbol = ((ScopeWithIr)object).getScope().getScopeOwnerSymbol();
                object = LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(EnumClassLowering.this.getContext(), scopeOwnerSymbol, 0, 0, 6, null), expression2);
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                boolean bl = false;
                boolean bl2 = false;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u2d3 = (DeclarationIrBuilder)object;
                boolean bl3 = false;
                IrConstructor irConstructor2 = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                IrElementBase irElementBase = irConstructor2 == null ? (IrConstructor)expression2.getSymbol().getOwner() : irConstructor2;
                Intrinsics.checkNotNullExpressionValue((Object)irElementBase, (String)"loweredEnumConstructors[expression.symbol] ?: expression.symbol.owner");
                IrConstructor constructor2 = irElementBase;
                irElementBase = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall($this$visitEnumConstructorCall_u24lambda_u2d3, constructor2) : ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u2d3, constructor2);
                boolean bl4 = false;
                boolean bl5 = false;
                IrElementBase it = irElementBase;
                boolean bl6 = false;
                this.passConstructorArguments($this$visitEnumConstructorCall_u24lambda_u2d3, (IrFunctionAccessExpression)it, expression2, (IrEnumEntry)enumClassTransformer.declarationToEnumEntry.get((IrDeclaration)scopeOwnerSymbol.getOwner()));
                return (IrExpression)irElementBase;
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor irConstructor2 = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor2 == null) {
                    return expression2;
                }
                Object object = irConstructor2;
                IrConstructor replacement = object;
                BackendContext backendContext = EnumClassLowering.this.getContext();
                object = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)object);
                object = LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(backendContext, ((ScopeWithIr)object).getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
                boolean bl = false;
                boolean bl2 = false;
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u2d5 = (DeclarationIrBuilder)object;
                boolean bl3 = false;
                IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall($this$visitDelegatingConstructorCall_u24lambda_u2d5, replacement);
                boolean bl4 = false;
                boolean bl5 = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall;
                boolean bl6 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, $this$visitDelegatingConstructorCall_u24lambda_u2d5, it, expression2, null, 4, null);
                return irDelegatingConstructorCall;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original, IrEnumEntry enumEntry) {
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(call2, original, 0, 2, null);
                if (enumEntry != null) {
                    String string2 = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
                    call2.putValueArgument(0, ExpressionHelpersKt.irString($this$passConstructorArguments, string2));
                    call2.putValueArgument(1, ExpressionHelpersKt.irInt$default($this$passConstructorArguments, EnumClassTransformer.this.enumEntryOrdinals.get((Object)enumEntry), null, 2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    IrConstructorSymbol constructor2 = (IrConstructorSymbol)scopeWithIr.getScope().getScopeOwnerSymbol();
                    call2.putValueArgument(0, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(0)));
                    call2.putValueArgument(1, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(1)));
                }
                int n = 0;
                int n2 = original.getValueArgumentsCount();
                if (n < n2) {
                    do {
                        int index2;
                        IrExpression irExpression;
                        if ((irExpression = original.getValueArgument(index2 = n++)) == null) continue;
                        IrExpression irExpression2 = irExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrExpression it = irExpression2;
                        boolean bl3 = false;
                        call2.putValueArgument(index2 + 2, it);
                    } while (n < n2);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n, Object object) {
                if ((n & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }
    }
}

