/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/AsDynamicFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/CompositeFIF;", "()V", "js.translator"})
public final class AsDynamicFIF
extends CompositeFIF {
    public static final AsDynamicFIF INSTANCE;

    private AsDynamicFIF() {
    }

    static {
        AsDynamicFIF asDynamicFIF;
        INSTANCE = asDynamicFIF = new AsDynamicFIF();
        asDynamicFIF.add(PatternBuilder.pattern("kotlin.js.asDynamic()"), new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
                Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
                Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                JsExpression jsExpression = callInfo.getExtensionReceiver();
                if (jsExpression == null) {
                    Intrinsics.throwNpe();
                }
                ReceiverValue receiverValue = callInfo.getResolvedCall().getExtensionReceiver();
                if (receiverValue == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"callInfo.resolvedCall.extensionReceiver!!");
                JsExpression jsExpression2 = TranslationUtils.coerce(context2, jsExpression, receiverValue.getType());
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"TranslationUtils.coerce(\u2026extensionReceiver!!.type)");
                return jsExpression2;
            }
        });
    }
}

