/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.backend.js.utils.ParameterTypeBasedSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.Signature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNameSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollector;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020!R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "", "packages", "", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "(Ljava/util/List;)V", "globalNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getGlobalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "localNames", "", "loopNames", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "", "memberNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Signature;", "dump", "generateNameForMemberField", "", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateNameForMemberFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateNamesForTopLevelDecl", "getNameForLoop", "loop", "getNameForMemberField", "getNameForMemberFunction", "function", "getNameForStaticDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "LocalNameGenerator", "backend.js"})
public final class NameTables {
    @NotNull
    private final NameTable<IrDeclaration> globalNames;
    private final NameTable<Signature> memberNames;
    private final Map<IrDeclaration, NameTable<IrDeclaration>> localNames;
    private final Map<IrLoop, String> loopNames;

    @NotNull
    public final NameTable<IrDeclaration> getGlobalNames() {
        return this.globalNames;
    }

    private final void generateNameForMemberField(IrField field) {
        boolean bl = !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel(field);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = !field.isStatic();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        Signature signature = NameTablesKt.fieldSignature(field);
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string4 = field.getName().getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"field.name.identifier");
            this.memberNames.declareStableName(signature, string4);
        }
        StringBuilder stringBuilder = new StringBuilder().append("_");
        String string5 = field.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"field.name.asString()");
        this.memberNames.declareFreshName(signature, stringBuilder.append(NameTablesKt.sanitizeName(string5)).toString());
    }

    private final void generateNameForMemberFunction(IrSimpleFunction declaration2) {
        Signature signature = NameTablesKt.functionSignature(declaration2);
        if (signature instanceof StableNameSignature) {
            this.memberNames.declareStableName(signature, ((StableNameSignature)signature).getName());
        } else if (signature instanceof ParameterTypeBasedSignature) {
            String string2 = declaration2.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.name.asString()");
            if (StringsKt.startsWith$default((String)string2, (String)"invoke", (boolean)false, (int)2, null)) {
                this.memberNames.declareStableName(signature, NameTablesKt.sanitizeName(((ParameterTypeBasedSignature)signature).getMangledName()));
            } else {
                this.memberNames.declareFreshName(signature, ((ParameterTypeBasedSignature)signature).getSuggestedName());
            }
        }
    }

    @NotNull
    public final String dump() {
        String local2 = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.localNames), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.local.1.INSTANCE, (int)30, null);
        return "Global names:\n" + NameTablesKt.dump(this.globalNames) + "\nLocal names:\n" + local2 + '\n';
    }

    @NotNull
    public final String getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        String global = this.globalNames.getNames().get(declaration2);
        if (global != null) {
            return global;
        }
        if (declaration2 instanceof IrTypeParameter) {
            String string2 = declaration2.getName().getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.name.identifier");
            return string2;
        }
        IrDeclarationParent parent2 = declaration2.getParent();
        while (parent2 instanceof IrDeclaration) {
            String localName;
            NameTable<IrDeclaration> parentLocalNames = this.localNames.get(parent2);
            if (parentLocalNames != null && (localName = parentLocalNames.getNames().get(declaration2)) != null) {
                return localName;
            }
            parent2 = ((IrDeclaration)((Object)parent2)).getParent();
        }
        String string3 = "Can't find name for declaration " + IrUtilsKt.getFqNameWhenAvailable(declaration2);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string3.toString());
    }

    @NotNull
    public final String getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Signature signature = NameTablesKt.fieldSignature(field);
        String name = this.memberNames.getNames().get(signature);
        boolean bl = name != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can't find name for member field " + field;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return name;
    }

    @NotNull
    public final String getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Signature signature = NameTablesKt.functionSignature(function2);
        String name = this.memberNames.getNames().get(signature);
        if (name == null && signature instanceof ParameterTypeBasedSignature && StringsKt.startsWith$default((String)((ParameterTypeBasedSignature)signature).getSuggestedName(), (String)"invoke", (boolean)false, (int)2, null)) {
            return ((ParameterTypeBasedSignature)signature).getSuggestedName();
        }
        boolean bl = name != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can't find name for member function " + RenderIrElementKt.render(function2);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return name;
    }

    private final void generateNamesForTopLevelDecl(IrDeclaration declaration2) {
        if (!(declaration2 instanceof IrDeclarationWithName)) {
            return;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration2).getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.getJsNameOrKotlinName().identifier");
            this.globalNames.declareStableName(declaration2, string2);
        } else {
            String string3 = ((IrDeclarationWithName)declaration2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"declaration.name.asString()");
            this.globalNames.declareFreshName(declaration2, string3);
        }
    }

    @Nullable
    public final String getNameForLoop(@NotNull IrLoop loop2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        if (loop2.getLabel() == null) {
            string2 = null;
        } else {
            String string3 = this.loopNames.get(loop2);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string2 = string3;
        }
        return string2;
    }

    public NameTables(@NotNull List<? extends IrPackageFragment> packages2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(packages2, (String)"packages");
        NameTables nameTables = this;
        boolean bl = false;
        nameTables.localNames = map2 = (Map)new LinkedHashMap();
        nameTables = this;
        bl = false;
        nameTables.loopNames = map2 = (Map)new LinkedHashMap();
        StableNamesCollector stableNamesCollector = new StableNamesCollector();
        Iterable iterable = packages2;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            IrPackageFragment it = (IrPackageFragment)element$iv;
            boolean bl2 = false;
            IrElementVisitorVoidKt.acceptChildrenVoid(it, stableNamesCollector);
        }
        this.globalNames = new NameTable(null, stableNamesCollector.getStaticNames(), null, 5, null);
        this.memberNames = new NameTable(null, stableNamesCollector.getMemberNames(), null, 5, null);
        for (IrPackageFragment irPackageFragment : packages2) {
            for (IrDeclaration declaration2 : irPackageFragment.getDeclarations()) {
                this.generateNamesForTopLevelDecl(declaration2);
            }
        }
        this.globalNames.setFinished(true);
        for (IrPackageFragment irPackageFragment : packages2) {
            for (IrDeclaration declaration2 : irPackageFragment.getDeclarations()) {
                LocalNameGenerator localNameGenerator = new LocalNameGenerator(declaration2);
                if (declaration2 instanceof IrClass) {
                    if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
                        IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, new IrElementVisitorVoid(){

                            @Override
                            public void visitElement(@NotNull IrElement element) {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                            }

                            @Override
                            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrDeclarationParent parent2 = declaration2.getParent();
                                if (parent2 instanceof IrClass && !IrUtilsKt.isEnumClass((IrClass)parent2)) {
                                    this.generateNameForMemberFunction(declaration2);
                                }
                            }

                            @Override
                            public void visitField(@NotNull IrField declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrDeclarationParent parent2 = declaration2.getParent();
                                if (parent2 instanceof IrClass && !IrUtilsKt.isEnumClass((IrClass)parent2)) {
                                    this.generateNameForMemberField(declaration2);
                                }
                            }

                            @Override
                            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                            }

                            @Override
                            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                            }

                            @Override
                            public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                            }

                            @Override
                            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                            }

                            @Override
                            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                            }

                            @Override
                            public void visitBlock(@NotNull IrBlock expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                            }

                            @Override
                            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                            }

                            @Override
                            public void visitBlockBody(@NotNull IrBlockBody body2) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                            }

                            @Override
                            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                            }

                            @Override
                            public void visitBody(@NotNull IrBody body2) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                            }

                            @Override
                            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                            }

                            @Override
                            public void visitBranch(@NotNull IrBranch branch) {
                                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                            }

                            @Override
                            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                            }

                            @Override
                            public void visitBreak(@NotNull IrBreak jump) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                            }

                            @Override
                            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                            }

                            @Override
                            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                            }

                            @Override
                            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                            }

                            @Override
                            public void visitCall(@NotNull IrCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                            }

                            @Override
                            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                            }

                            @Override
                            public void visitCallableReference(@NotNull IrCallableReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                            }

                            @Override
                            public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                            }

                            @Override
                            public void visitCatch(@NotNull IrCatch aCatch) {
                                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                            }

                            @Override
                            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                            }

                            @Override
                            public void visitClass(@NotNull IrClass declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                            }

                            @Override
                            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                            }

                            @Override
                            public void visitClassReference(@NotNull IrClassReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                            }

                            @Override
                            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                            }

                            @Override
                            public void visitComposite(@NotNull IrComposite expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                            }

                            @Override
                            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                            }

                            @Override
                            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                            }

                            @Override
                            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                            }

                            @Override
                            public void visitConstructor(@NotNull IrConstructor declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                            }

                            @Override
                            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                            }

                            @Override
                            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                            }

                            @Override
                            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                            }

                            @Override
                            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                            }

                            @Override
                            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                            }

                            @Override
                            public void visitContinue(@NotNull IrContinue jump) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                            }

                            @Override
                            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                            }

                            @Override
                            public void visitDeclaration(@NotNull IrDeclaration declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                            }

                            @Override
                            public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                            }

                            @Override
                            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                            }

                            @Override
                            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                            }

                            @Override
                            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                            }

                            @Override
                            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                            }

                            @Override
                            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                            }

                            @Override
                            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                            }

                            @Override
                            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                            }

                            @Override
                            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                            }

                            @Override
                            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                            }

                            @Override
                            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                            }

                            @Override
                            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                            }

                            @Override
                            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                            }

                            @Override
                            public void visitElseBranch(@NotNull IrElseBranch branch) {
                                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                            }

                            @Override
                            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                            }

                            @Override
                            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                            }

                            @Override
                            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                            }

                            @Override
                            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                            }

                            @Override
                            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                            }

                            @Override
                            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                            }

                            @Override
                            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                            }

                            @Override
                            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                            }

                            @Override
                            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                            }

                            @Override
                            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                            }

                            @Override
                            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                            }

                            @Override
                            public void visitExpression(@NotNull IrExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                            }

                            @Override
                            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                            }

                            @Override
                            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                            }

                            @Override
                            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                            }

                            @Override
                            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                            }

                            @Override
                            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                            }

                            @Override
                            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                            }

                            @Override
                            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                            }

                            @Override
                            public void visitFile(@NotNull IrFile declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                            }

                            @Override
                            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                            }

                            @Override
                            public void visitFunction(@NotNull IrFunction declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                            }

                            @Override
                            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                            }

                            @Override
                            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                            }

                            @Override
                            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                            }

                            @Override
                            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                            }

                            @Override
                            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                            }

                            @Override
                            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                            }

                            @Override
                            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                            }

                            @Override
                            public void visitGetClass(@NotNull IrGetClass expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                            }

                            @Override
                            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                            }

                            @Override
                            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                            }

                            @Override
                            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                            }

                            @Override
                            public void visitGetField(@NotNull IrGetField expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                            }

                            @Override
                            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                            }

                            @Override
                            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                            }

                            @Override
                            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                            }

                            @Override
                            public void visitGetValue(@NotNull IrGetValue expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                            }

                            @Override
                            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                            }

                            @Override
                            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                            }

                            @Override
                            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                            }

                            @Override
                            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                            }

                            @Override
                            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                            }

                            @Override
                            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                            }

                            @Override
                            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                            }

                            @Override
                            public void visitLoop(@NotNull IrLoop loop2) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                            }

                            @Override
                            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                            }

                            @Override
                            public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                            }

                            @Override
                            public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                            }

                            @Override
                            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                            }

                            @Override
                            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                            }

                            @Override
                            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                            }

                            @Override
                            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                            }

                            @Override
                            public void visitProperty(@NotNull IrProperty declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                            }

                            @Override
                            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                            }

                            @Override
                            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                            }

                            @Override
                            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                            }

                            @Override
                            public void visitReturn(@NotNull IrReturn expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                            }

                            @Override
                            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                            }

                            @Override
                            public void visitSetField(@NotNull IrSetField expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                            }

                            @Override
                            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                            }

                            @Override
                            public void visitSetVariable(@NotNull IrSetVariable expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
                            }

                            @Override
                            public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
                            }

                            @Override
                            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                            }

                            @Override
                            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                            }

                            @Override
                            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                            }

                            @Override
                            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                            }

                            @Override
                            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                            }

                            @Override
                            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                            }

                            @Override
                            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                            }

                            @Override
                            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                            }

                            @Override
                            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                            }

                            @Override
                            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                            }

                            @Override
                            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                            }

                            @Override
                            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                            }

                            @Override
                            public void visitThrow(@NotNull IrThrow expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                            }

                            @Override
                            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                            }

                            @Override
                            public void visitTry(@NotNull IrTry aTry) {
                                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                            }

                            @Override
                            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                            }

                            @Override
                            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                            }

                            @Override
                            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                            }

                            @Override
                            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                            }

                            @Override
                            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                            }

                            @Override
                            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                            }

                            @Override
                            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                            }

                            @Override
                            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                            }

                            @Override
                            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                            }

                            @Override
                            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                            }

                            @Override
                            public void visitVararg(@NotNull IrVararg expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                            }

                            @Override
                            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                            }

                            @Override
                            public void visitVariable(@NotNull IrVariable declaration2) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                            }

                            @Override
                            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                            }

                            @Override
                            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
                            }

                            @Override
                            public void visitWhen(@NotNull IrWhen expression2) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                            }

                            @Override
                            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                            }

                            @Override
                            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                            }

                            @Override
                            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                            }
                        });
                        continue;
                    }
                    IrValueParameter irValueParameter = ((IrClass)declaration2).getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    IrElementVisitorVoidKt.acceptVoid(irValueParameter, localNameGenerator);
                    for (IrDeclaration memberDecl : ((IrClass)declaration2).getDeclarations()) {
                        IrElementVisitorVoidKt.acceptChildrenVoid(memberDecl, new LocalNameGenerator(memberDecl));
                        IrDeclaration irDeclaration2 = memberDecl;
                        if (irDeclaration2 instanceof IrSimpleFunction) {
                            this.generateNameForMemberFunction((IrSimpleFunction)memberDecl);
                            continue;
                        }
                        if (!(irDeclaration2 instanceof IrField)) continue;
                        this.generateNameForMemberField((IrField)memberDecl);
                    }
                    continue;
                }
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, localNameGenerator);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables$LocalNameGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "parentDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "localLoopNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "table", "getTable", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "visitDeclaration", "", "declaration", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitLoop", "loop", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.js"})
    public final class LocalNameGenerator
    implements IrElementVisitorVoid {
        @NotNull
        private final NameTable<IrDeclaration> table;
        private final NameTable<IrLoop> localLoopNames;

        @NotNull
        public final NameTable<IrDeclaration> getTable() {
            return this.table;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            if (!(irDeclarationParent instanceof IrFunction)) {
                irDeclarationParent = null;
            }
            IrFunction parentFunction = (IrFunction)irDeclarationParent;
            if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE) && declaration2.getName().isSpecial() || parentFunction != null && Intrinsics.areEqual((Object)declaration2, (Object)parentFunction.getDispatchReceiverParameter())) {
                this.table.declareStableName(declaration2, Namer.INSTANCE.getIMPLICIT_RECEIVER_NAME());
            } else {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            if (declaration2 instanceof IrDeclarationWithName && declaration2 instanceof IrSymbolOwner) {
                String string2 = ((IrDeclarationWithName)declaration2).getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"declaration.name.asString()");
                this.table.declareFreshName(declaration2, string2);
            }
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            String label = loop2.getLabel();
            if (label != null) {
                this.localLoopNames.declareFreshName(loop2, label);
                Map map2 = NameTables.this.loopNames;
                String string2 = this.localLoopNames.getNames().get(loop2);
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                map2.put(loop2, string2);
            }
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        public LocalNameGenerator(IrDeclaration parentDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)parentDeclaration, (String)"parentDeclaration");
            this.table = new NameTable(NameTables.this.getGlobalNames(), null, null, 6, null);
            NameTables.this.localNames.put(parentDeclaration, this.table);
            this.localLoopNames = new NameTable(null, null, null, 7, null);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

