/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ast;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ast.WasmAstToWatKt;
import org.jetbrains.kotlin.backend.wasm.ast.WasmExport;
import org.jetbrains.kotlin.backend.wasm.ast.WasmFunction;
import org.jetbrains.kotlin.backend.wasm.ast.WasmGlobal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmImmediate;
import org.jetbrains.kotlin.backend.wasm.ast.WasmInstruction;
import org.jetbrains.kotlin.backend.wasm.ast.WasmLocal;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModule;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModuleField;
import org.jetbrains.kotlin.backend.wasm.ast.WasmModuleFieldList;
import org.jetbrains.kotlin.backend.wasm.ast.WasmParameter;
import org.jetbrains.kotlin.backend.wasm.ast.WasmValueType;
import org.jetbrains.kotlin.backend.wasm.utils.WasmImportPair;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u001b\u001a\u0014\u0010\u001a\u001a\u00020\u0001*\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0001\u00a8\u0006\u001e"}, d2={"toWasString", "", "s", "wasmExportToWat", "export", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmExport;", "wasmFunctionToWat", "function", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmFunction;", "wasmGlobalToWat", "global", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmGlobal;", "wasmLocalToWat", "local", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmLocal;", "wasmModuleFieldToWat", "moduleField", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmModuleField;", "wasmModuleToWat", "module", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmModule;", "wasmParameterToWat", "parameter", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmParameter;", "includeName", "", "toWat", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmImmediate;", "Lorg/jetbrains/kotlin/backend/wasm/ast/WasmInstruction;", "ident", "backend.wasm"})
public final class WasmAstToWatKt {
    @NotNull
    public static final String toWat(@NotNull WasmInstruction $this$toWat, @NotNull String ident) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toWat, (String)"$this$toWat");
        Intrinsics.checkParameterIsNotNull((Object)ident, (String)"ident");
        return ident + '(' + $this$toWat.getMnemonic() + WasmAstToWatKt.toWat($this$toWat.getImmediate()) + CollectionsKt.joinToString$default((Iterable)$this$toWat.getOperands(), (CharSequence)"", null, null, (int)0, null, (Function1)toWat.1.INSTANCE, (int)30, null) + ')';
    }

    public static /* synthetic */ String toWat$default(WasmInstruction wasmInstruction, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        return WasmAstToWatKt.toWat(wasmInstruction, string2);
    }

    @NotNull
    public static final String toWat(@NotNull WasmImmediate $this$toWat) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toWat, (String)"$this$toWat");
        WasmImmediate wasmImmediate = $this$toWat;
        if (Intrinsics.areEqual((Object)wasmImmediate, (Object)WasmImmediate.None.INSTANCE)) {
            string2 = "";
        } else if (wasmImmediate instanceof WasmImmediate.DeclarationReference) {
            string2 = " $" + ((WasmImmediate.DeclarationReference)$this$toWat).getName();
        } else if (wasmImmediate instanceof WasmImmediate.LiteralValue) {
            string2 = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly("" + ' ' + ((WasmImmediate.LiteralValue)$this$toWat).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public static final String wasmModuleToWat(@NotNull WasmModule module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        return "(module\n" + CollectionsKt.joinToString$default((Iterable)module2.getFields(), (CharSequence)"", null, null, (int)0, null, (Function1)wasmModuleToWat.1.INSTANCE, (int)30, null) + ')';
    }

    @NotNull
    public static final String wasmFunctionToWat(@NotNull WasmFunction function2) {
        Object object;
        String watParameters2;
        String watLocals2;
        Object watImport;
        String watId;
        block7: {
            block6: {
                Object importPair;
                Object object2;
                block5: {
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                        watId = '$' + function2.getName();
                        object2 = function2.getImportPair();
                        if (object2 == null) break block4;
                        WasmImportPair wasmImportPair = object2;
                        boolean bl = false;
                        boolean bl2 = false;
                        importPair = wasmImportPair;
                        boolean bl3 = false;
                        object2 = " (import " + WasmAstToWatKt.toWasString(((WasmImportPair)importPair).getModule()) + ' ' + WasmAstToWatKt.toWasString(((WasmImportPair)importPair).getName()) + ')';
                        if (object2 != null) break block5;
                    }
                    object2 = "";
                }
                watImport = object2;
                watLocals2 = CollectionsKt.joinToString$default((Iterable)function2.getLocals(), (CharSequence)"", null, null, (int)0, null, (Function1)wasmFunctionToWat.watLocals.1.INSTANCE, (int)30, null);
                watParameters2 = CollectionsKt.joinToString$default((Iterable)function2.getParameters(), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<WasmParameter, CharSequence>(function2){
                    final /* synthetic */ WasmFunction $function;

                    @NotNull
                    public final CharSequence invoke(@NotNull WasmParameter it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return " " + WasmAstToWatKt.wasmParameterToWat(it, this.$function.getImportPair() == null);
                    }
                    {
                        this.$function = wasmFunction;
                        super(1);
                    }
                }), (int)30, null);
                object = function2.getReturnType();
                if (object == null) break block6;
                importPair = object;
                boolean bl = false;
                boolean bl4 = false;
                Object type2 = importPair;
                boolean bl5 = false;
                object = " (result " + ((WasmValueType)type2).getMnemonic() + ')';
                if (object != null) break block7;
            }
            object = "";
        }
        Object watResult = object;
        String watBody2 = CollectionsKt.joinToString$default((Iterable)function2.getInstructions(), (CharSequence)"", null, null, (int)0, null, (Function1)wasmFunctionToWat.watBody.1.INSTANCE, (int)30, null);
        return "  (func " + watId + (String)watImport + watParameters2 + (String)watResult + '\n' + watLocals2 + watBody2 + "  )";
    }

    @NotNull
    public static final String wasmParameterToWat(@NotNull WasmParameter parameter, boolean includeName) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        String name = includeName ? " $" + parameter.getName() : "";
        return "(param" + name + ' ' + parameter.getType().getMnemonic() + ')';
    }

    @NotNull
    public static final String wasmLocalToWat(@NotNull WasmLocal local2) {
        Intrinsics.checkParameterIsNotNull((Object)local2, (String)"local");
        WasmLocal wasmLocal = local2;
        boolean bl = false;
        boolean bl2 = false;
        WasmLocal $this$run = wasmLocal;
        boolean bl3 = false;
        return "(local $" + $this$run.getName() + ' ' + $this$run.getType().getMnemonic() + ')';
    }

    @NotNull
    public static final String wasmGlobalToWat(@NotNull WasmGlobal global) {
        Intrinsics.checkParameterIsNotNull((Object)global, (String)"global");
        String watMut = global.isMutable() ? "mut " : "";
        Object object = global.getInit();
        if (object == null || (object = WasmAstToWatKt.toWat((WasmInstruction)object, "")) == null) {
            object = "";
        }
        Object watInit = object;
        WasmGlobal wasmGlobal = global;
        boolean bl = false;
        boolean bl2 = false;
        WasmGlobal $this$run = wasmGlobal;
        boolean bl3 = false;
        return "  (global $" + $this$run.getName() + " (" + watMut + $this$run.getType().getMnemonic() + ") " + (String)watInit + ')';
    }

    @NotNull
    public static final String wasmExportToWat(@NotNull WasmExport export) {
        Intrinsics.checkParameterIsNotNull((Object)export, (String)"export");
        WasmExport wasmExport = export;
        boolean bl = false;
        boolean bl2 = false;
        WasmExport $this$run = wasmExport;
        boolean bl3 = false;
        return "  (export \"" + $this$run.getExportedName() + "\" (" + $this$run.getKind().getKeyword() + " $" + $this$run.getWasmName() + "))";
    }

    @NotNull
    public static final String wasmModuleFieldToWat(@NotNull WasmModuleField moduleField) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)moduleField, (String)"moduleField");
        WasmModuleField wasmModuleField = moduleField;
        if (wasmModuleField instanceof WasmFunction) {
            string2 = WasmAstToWatKt.wasmFunctionToWat((WasmFunction)moduleField);
        } else if (wasmModuleField instanceof WasmGlobal) {
            string2 = WasmAstToWatKt.wasmGlobalToWat((WasmGlobal)moduleField);
        } else if (wasmModuleField instanceof WasmExport) {
            string2 = WasmAstToWatKt.wasmExportToWat((WasmExport)moduleField);
        } else if (wasmModuleField instanceof WasmModuleFieldList) {
            string2 = CollectionsKt.joinToString$default((Iterable)((WasmModuleFieldList)moduleField).getFields(), (CharSequence)"", null, null, (int)0, null, (Function1)wasmModuleFieldToWat.1.INSTANCE, (int)30, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public static final String toWasString(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return "\"" + s + "\"";
    }
}

