/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonReferencesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "constructingEnums", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "Lkotlin/collections/ArrayList;", "containingClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isInScope", "", "symbol", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "isVisitingSuperConstructor", "irClass", "lower", "", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "backend.jvm"})
final class SingletonReferencesLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    private IrClass containingClass;
    private final ArrayList<IrDeclarationParent> constructingEnums;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        this.containingClass = irClass;
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
    }

    @Override
    @NotNull
    public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        UtilsKt.push(this.constructingEnums, ((IrConstructor)expression2.getSymbol().getOwner()).getParent());
        IrExpression call2 = super.visitEnumConstructorCall(expression2);
        UtilsKt.pop(this.constructingEnums);
        return call2;
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrClass candidate2 = ((IrEnumEntry)expression2.getSymbol().getOwner()).getCorrespondingClass();
        if (candidate2 != null && this.isInScope(candidate2) && !this.isVisitingSuperConstructor(candidate2)) {
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            IrValueParameter irValueParameter = candidate2.getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            irExpression = new IrGetValueImpl(n, n2, irType, (IrValueSymbol)irValueParameter.getSymbol(), null, 16, null);
        } else {
            IrField entrySymbol = this.context.getDeclarationFactory().getFieldForEnumEntry((IrEnumEntry)expression2.getSymbol().getOwner(), expression2.getType());
            irExpression = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)entrySymbol.getSymbol(), expression2.getType(), null, null, 48, null);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrField instanceField = this.context.getDeclarationFactory().getFieldForObjectInstance((IrClass)expression2.getSymbol().getOwner());
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)instanceField.getSymbol(), expression2.getType(), null, null, 48, null);
    }

    private final boolean isInScope(IrSymbolOwner symbol2) {
        IrClass irClass = this.containingClass;
        if (irClass == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containingClass");
        }
        IrDeclaration candidate2 = irClass;
        while (candidate2 != null && Intrinsics.areEqual((Object)symbol2, (Object)candidate2) ^ true) {
            IrDeclarationParent irDeclarationParent = candidate2.getParent();
            if (!(irDeclarationParent instanceof IrDeclaration)) {
                irDeclarationParent = null;
            }
            candidate2 = (IrDeclaration)((Object)irDeclarationParent);
        }
        return candidate2 != null;
    }

    private final boolean isVisitingSuperConstructor(IrClass irClass) {
        return Intrinsics.areEqual((Object)irClass.getParent(), (Object)((IrDeclarationParent)CollectionsKt.lastOrNull((List)this.constructingEnums)));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public SingletonReferencesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        SingletonReferencesLowering singletonReferencesLowering = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        singletonReferencesLowering.constructingEnums = arrayList;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

